/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.EditorPaneLinkVisitor;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXEditorPaneTest;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.ConditionalHighlighter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.ShuttleSorter;

public class JXListTest
extends InteractiveTestCase {
    private ListModel listModel;
    protected DefaultListModel ascendingListModel;
    static /* synthetic */ Class class$0;

    public void testLinkControllerListening() {
        JXList table = new JXList();
        table.setRolloverEnabled(true);
        JXListTest.assertNotNull((String)"LinkController must be listening", (Object)this.getLinkControllerAsPropertyChangeListener(table));
        JXListTest.assertNotNull((String)"execute button action must be registered", (Object)table.getActionMap().get("executeButtonAction"));
        table.setRolloverEnabled(false);
        JXListTest.assertNull((String)"LinkController must not be listening", (Object)this.getLinkControllerAsPropertyChangeListener(table));
        JXListTest.assertNull((String)"execute button action must be de-registered", (Object)table.getActionMap().get("executeButtonAction"));
    }

    private PropertyChangeListener getLinkControllerAsPropertyChangeListener(JXList table) {
        PropertyChangeListener[] listeners = table.getPropertyChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof JXList.LinkController) {
                return (JXList.LinkController)listeners[i];
            }
            ++i;
        }
        return null;
    }

    public void testConvertToModelPreconditions() {
        JXList list = new JXList((ListModel)this.ascendingListModel);
        list.setFilterEnabled(true);
        JXListTest.assertEquals((int)20, (int)list.getElementCount());
        list.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("0", 0, 0)}));
        JXListTest.assertEquals((int)2, (int)list.getElementCount());
        try {
            list.convertIndexToModel(list.getElementCount());
            JXListTest.fail((String)"accessing list out of range index must throw execption");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception ex) {
            JXListTest.fail((String)("got " + ex));
        }
    }

    public void testElementAtPreconditions() {
        JXList list = new JXList((ListModel)this.ascendingListModel);
        list.setFilterEnabled(true);
        JXListTest.assertEquals((int)20, (int)list.getElementCount());
        list.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("0", 0, 0)}));
        JXListTest.assertEquals((int)2, (int)list.getElementCount());
        try {
            list.getElementAt(list.getElementCount());
            JXListTest.fail((String)"accessing list out of range index must throw execption");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception ex) {
            JXListTest.fail((String)("got " + ex));
        }
    }

    public void testSelectionListenerNotification() {
        final JXList list = new JXList((ListModel)this.ascendingListModel);
        list.setFilterEnabled(true);
        JXListTest.assertEquals((int)20, (int)list.getElementCount());
        boolean modelRow = false;
        list.setSelectedIndex(0);
        ListSelectionListener l = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int viewRow = list.getSelectedIndex();
                JXListTest.assertEquals((String)"view index visible", (int)0, (int)viewRow);
                list.convertIndexToModel(viewRow);
            }
        };
        list.getSelectionModel().addListSelectionListener(l);
        list.setFilters(new FilterPipeline(new Filter[]{new PatternFilter("0", 0, 0)}));
        JXListTest.assertEquals((int)2, (int)list.getElementCount());
    }

    public void testSetFilterEnabledWithSelection() {
        JXList list = new JXList((ListModel)this.ascendingListModel);
        JXListTest.assertEquals((int)20, (int)list.getElementCount());
        boolean modelRow = false;
        list.setSelectedIndex(0);
        list.setFilterEnabled(true);
    }

    public void testEmptyFilter() {
        JXList list = new JXList();
        list.setModel((ListModel)this.ascendingListModel);
        JXListTest.assertEquals((int)this.ascendingListModel.getSize(), (int)list.getElementCount());
        JXListTest.assertEquals(this.ascendingListModel.getElementAt(0), (Object)list.getElementAt(0));
    }

    public void testFilterEnabled() {
        JXList list = new JXList();
        list.setFilterEnabled(true);
        list.setModel((ListModel)this.ascendingListModel);
        JXListTest.assertNotSame((Object)this.ascendingListModel, list.getModel());
        JXListTest.assertEquals((int)this.ascendingListModel.getSize(), (int)list.getElementCount());
        JXListTest.assertEquals(this.ascendingListModel.getElementAt(0), (Object)list.getElementAt(0));
    }

    public void testFilterEnabledAndDisabled() {
        JXList list = new JXList();
        list.setFilterEnabled(true);
        list.setModel((ListModel)this.ascendingListModel);
        ShuttleSorter sorter = new ShuttleSorter(0, false);
        FilterPipeline pipeline = list.getFilters();
        pipeline.setSorter(sorter);
        list.setFilterEnabled(false);
        JXListTest.assertSame((Object)this.ascendingListModel, list.getModel());
        JXListTest.assertEquals((int)this.ascendingListModel.getSize(), (int)list.getElementCount());
        JXListTest.assertEquals(this.ascendingListModel.getElementAt(0), (Object)list.getElementAt(0));
    }

    public void testSortingFilterEnabled() {
        JXList list = new JXList();
        list.setFilterEnabled(true);
        list.setModel((ListModel)this.ascendingListModel);
        ShuttleSorter sorter = new ShuttleSorter(0, false);
        FilterPipeline pipeline = list.getFilters();
        JXListTest.assertNotNull((Object)pipeline);
        pipeline.setSorter(sorter);
        JXListTest.assertEquals((int)this.ascendingListModel.getSize(), (int)list.getElementCount());
        JXListTest.assertEquals(this.ascendingListModel.getElementAt(0), (Object)list.getElementAt(list.getElementCount() - 1));
    }

    public void testSortingKeepsModelSelection() {
        JXList list = new JXList();
        list.setFilterEnabled(true);
        list.setModel((ListModel)this.ascendingListModel);
        list.setSelectedIndex(0);
        ShuttleSorter sorter = new ShuttleSorter(0, false);
        FilterPipeline pipeline = list.getFilters();
        pipeline.setSorter(sorter);
        JXListTest.assertEquals((String)"last row must be selected after sorting", (int)(this.ascendingListModel.getSize() - 1), (int)list.getSelectedIndex());
    }

    public void testSelectionAfterDeleteAbove() {
        JXList list = new JXList();
        list.setFilterEnabled(true);
        list.setModel((ListModel)this.ascendingListModel);
        list.setSelectedIndex(1);
        this.ascendingListModel.remove(0);
        JXListTest.assertEquals((String)"first row must be selected removing old first", (int)0, (int)list.getSelectedIndex());
    }

    public void testSortingFilterDisabled() {
        JXList list = new JXList();
        list.setModel((ListModel)this.ascendingListModel);
        ShuttleSorter sorter = new ShuttleSorter(0, false);
        FilterPipeline pipeline = list.getFilters();
    }

    public void interactiveTestFilterDisabled() {
        JXList list = new JXList();
        list.setModel((ListModel)this.ascendingListModel);
        Filter[] filter = new Filter[]{new PatternFilter("1", 0, 0)};
        list.setFilters(new FilterPipeline(filter));
        JXFrame frame = this.wrapWithScrollingInFrame(list, "filter disabled");
        frame.setVisible(true);
    }

    public void interactiveTestSorter() {
        JXList list = new JXList();
        list.setFilterEnabled(true);
        list.setModel((ListModel)this.ascendingListModel);
        final ShuttleSorter sorter = new ShuttleSorter(0, false);
        FilterPipeline pipeline = list.getFilters();
        pipeline.setSorter(sorter);
        AbstractAction action = new AbstractAction("Toggle Sort Order"){

            public void actionPerformed(ActionEvent e) {
                sorter.setAscending(!sorter.isAscending());
            }
        };
        JXFrame frame = this.wrapWithScrollingInFrame(list, "Toggle sorter");
        this.addAction(frame, action);
        frame.setVisible(true);
    }

    public void interactiveTestCompareFocusedCellBackground() {
        JXList xlist = new JXList(this.listModel);
        xlist.setBackground(new Color(245, 255, 245));
        JList list = new JList(this.listModel);
        list.setBackground(new Color(245, 255, 245));
        JXFrame frame = this.wrapWithScrollingInFrame(xlist, list, "unselectedd focused background: JXList/JList");
        frame.setVisible(true);
    }

    public void interactiveTestTablePatternFilter5() {
        JXList list = new JXList(this.listModel);
        String pattern = "Row";
        list.setHighlighters(new HighlighterPipeline(new Highlighter[]{new PatternHighlighter(null, Color.red, pattern, 0, 1)}));
        JXFrame frame = this.wrapWithScrollingInFrame(list, "PatternHighlighter: " + pattern);
        frame.setVisible(true);
    }

    public void interactiveTestTableAlternateHighlighter1() {
        JXList list = new JXList(this.listModel);
        list.setHighlighters(new HighlighterPipeline(new Highlighter[]{AlternateRowHighlighter.linePrinter}));
        JXFrame frame = this.wrapWithScrollingInFrame(list, "AlternateRowHighlighter - lineprinter");
        frame.setVisible(true);
    }

    public void interactiveTestRolloverHighlight() {
        JXList list = new JXList(this.listModel);
        list.setRolloverEnabled(true);
        ConditionalHighlighter conditional = new ConditionalHighlighter(new Color(240, 240, 224), null, -1, -1){

            protected boolean test(ComponentAdapter adapter) {
                Point p = (Point)adapter.getComponent().getClientProperty("swingx.rollover");
                return p != null && p.y == adapter.row;
            }
        };
        list.setHighlighters(new HighlighterPipeline(new Highlighter[]{conditional}));
        JXFrame frame = this.wrapWithScrollingInFrame(list, "rollover highlight");
        frame.setVisible(true);
    }

    public void interactiveTestRolloverHighlightAndLink() {
        JXList list = new JXList((ListModel)this.createListModelWithLinks());
        list.setLinkVisitor(new EditorPaneLinkVisitor());
        ConditionalHighlighter conditional = new ConditionalHighlighter(new Color(240, 240, 224), null, -1, -1){

            protected boolean test(ComponentAdapter adapter) {
                Point p = (Point)adapter.getComponent().getClientProperty("swingx.rollover");
                return p != null && p.y == adapter.row;
            }
        };
        list.setHighlighters(new HighlighterPipeline(new Highlighter[]{conditional}));
        JXFrame frame = this.wrapWithScrollingInFrame(list, "rollover highlight with links");
        frame.setVisible(true);
    }

    private ListModel createListModel() {
        JXList list = new JXList();
        return new DefaultComboBoxModel<Object>(list.getActionMap().allKeys());
    }

    private DefaultListModel createAscendingListModel(int startRow, int count) {
        DefaultListModel<Integer> l = new DefaultListModel<Integer>();
        int row = startRow;
        while (row < startRow + count) {
            l.addElement(new Integer(row));
            ++row;
        }
        return l;
    }

    private DefaultListModel createListModelWithLinks() {
        DefaultListModel<LinkModel> model = new DefaultListModel<LinkModel>();
        int i = 0;
        while (i < 20) {
            try {
                LinkModel link = new LinkModel("a link text " + i, null, new URL("http://some.dummy.url" + i));
                if (i == 1) {
                    URL url = JXEditorPaneTest.class.getResource("resources/test.html");
                    link = new LinkModel("a resource", null, url);
                }
                model.addElement(link);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return model;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.listModel = this.createListModel();
        this.ascendingListModel = this.createAscendingListModel(0, 20);
    }

    public JXListTest() {
        super("JXList Tests");
    }

    public static void main(String[] args) {
        JXListTest.setSystemLF(true);
        JXListTest test = new JXListTest();
        try {
            test.runInteractiveTests("interactive.*Disab.*");
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }
}

