/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.LinkRenderer;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.Sorter;

public class JXList
extends JList {
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected FilterPipeline filters;
    protected HighlighterPipeline highlighters;
    private ChangeListener highlighterChangeListener;
    protected ComponentAdapter dataAdapter;
    private RolloverProducer rolloverProducer;
    private LinkController linkController;
    private DelegatingRenderer delegatingRenderer;
    private WrappingListModel wrappingModel;
    private PipelineListener pipelineListener;
    private boolean filterEnabled;
    private SelectionMapper selectionMapper;
    private Searchable searchable;

    public JXList() {
        this.init();
    }

    public JXList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    public JXList(Object[] listData) {
        super(listData);
        this.init();
    }

    public JXList(Vector listData) {
        super(listData);
        this.init();
    }

    private void init() {
        Action findAction = this.createFindAction();
        this.getActionMap().put("find", findAction);
        KeyStroke findStroke = KeyStroke.getKeyStroke("control F");
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createFindAction() {
        UIAction findAction = new UIAction("find"){

            public void actionPerformed(ActionEvent e) {
                JXList.this.doFind();
            }
        };
        return findAction;
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new ListSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    protected LinkController getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected LinkController createLinkController() {
        return new LinkController();
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer r = new RolloverProducer(){

            protected void updateRolloverPoint(JComponent component, Point mousePoint) {
                int col;
                Rectangle cellBounds;
                JXList list = (JXList)component;
                int row = list.locationToIndex(mousePoint);
                if (row >= 0 && !(cellBounds = list.getCellBounds(row, row)).contains(mousePoint)) {
                    row = -1;
                }
                this.rollover.x = col = row < 0 ? -1 : 0;
                this.rollover.y = row;
            }
        };
        return r;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    public void setLinkVisitor(ActionListener linkVisitor) {
        if (linkVisitor != null) {
            this.setRolloverEnabled(true);
            this.getDelegatingRenderer().setLinkVisitor(linkVisitor);
        }
    }

    public Object getElementAt(int viewIndex) {
        return this.getModel().getElementAt(viewIndex);
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public int convertIndexToModel(int viewIndex) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToModel(viewIndex) : viewIndex;
    }

    public int convertIndexToView(int modelIndex) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToView(modelIndex) : modelIndex;
    }

    public ListModel getWrappedModel() {
        return this.isFilterEnabled() ? this.wrappingModel.getModel() : this.getModel();
    }

    public void setFilterEnabled(boolean enabled) {
        boolean old = this.isFilterEnabled();
        if (old == enabled) {
            return;
        }
        this.filterEnabled = enabled;
        if (!old) {
            this.wrappingModel = new WrappingListModel(this.getModel());
            super.setModel(this.wrappingModel);
        } else {
            ListModel model = this.wrappingModel.getModel();
            this.wrappingModel = null;
            super.setModel(model);
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setModel(ListModel model) {
        if (this.isFilterEnabled()) {
            this.wrappingModel.setModel(model);
        } else {
            super.setModel(model);
        }
    }

    private SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = new SelectionMapper(this.filters, this.getSelectionModel());
        }
        return this.selectionMapper;
    }

    public FilterPipeline getFilters() {
        if (this.filters == null && this.isFilterEnabled()) {
            this.setFilters(null);
        }
        return this.filters;
    }

    public void setFilters(FilterPipeline pipeline) {
        if (!this.isFilterEnabled()) {
            throw new IllegalStateException("filters not enabled - not allowed to set filters");
        }
        FilterPipeline old = this.filters;
        Sorter sorter = null;
        if (old != null) {
            old.removePipelineListener(this.pipelineListener);
            sorter = old.getSorter();
        }
        if (pipeline == null) {
            pipeline = new FilterPipeline();
        }
        this.filters = pipeline;
        this.filters.setSorter(sorter);
        this.use(this.filters);
        this.getSelectionMapper().setFilters(this.filters);
    }

    private void use(FilterPipeline pipeline) {
        if (pipeline != null) {
            if (this.initialUse(pipeline)) {
                pipeline.addPipelineListener(this.getFilterPipelineListener());
                pipeline.assign(this.getComponentAdapter());
            } else {
                pipeline.flush();
            }
        }
    }

    private boolean initialUse(FilterPipeline pipeline) {
        if (this.pipelineListener == null) {
            return true;
        }
        PipelineListener[] l = pipeline.getPipelineListeners();
        int i = 0;
        while (i < l.length) {
            if (this.pipelineListener.equals(l[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected PipelineListener getFilterPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = this.createPipelineListener();
        }
        return this.pipelineListener;
    }

    protected PipelineListener createPipelineListener() {
        PipelineListener l = new PipelineListener(){

            public void contentsChanged(PipelineEvent e) {
                JXList.this.updateOnFilterContentChanged();
            }
        };
        return l;
    }

    protected void updateOnFilterContentChanged() {
        if (this.wrappingModel != null) {
            this.wrappingModel.updateOnFilterContentChanged();
        }
        this.revalidate();
        this.repaint();
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new ListAdapter(this);
        }
        return this.dataAdapter;
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline pipeline) {
        HighlighterPipeline old = this.getHighlighters();
        if (old != null) {
            old.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters = pipeline;
        if (this.highlighters != null) {
            this.highlighters.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JXList.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer(super.getCellRenderer());
        }
        return this.delegatingRenderer;
    }

    public ListCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    public void updateUI() {
        super.updateUI();
        this.updateRendererUI();
    }

    private void updateRendererUI() {
        if (this.delegatingRenderer != null) {
            this.delegatingRenderer.updateUI();
        } else {
            ListCellRenderer renderer = this.getCellRenderer();
            if (renderer instanceof JComponent) {
                ((JComponent)((Object)renderer)).updateUI();
            }
        }
    }

    public class ListSearchable
    extends AbstractSearchable {
        protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
            AbstractSearchable.SearchResult searchResult = null;
            if (backwards) {
                int index = startRow;
                while (index >= 0 && searchResult == null) {
                    searchResult = this.findMatchAt(pattern, index);
                    --index;
                }
            } else {
                int index = startRow;
                while (index < this.getSize() && searchResult == null) {
                    searchResult = this.findMatchAt(pattern, index);
                    ++index;
                }
            }
            this.updateState(searchResult);
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
            return this.findMatchAt(pattern, row);
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row) {
            Matcher matcher;
            Object value = JXList.this.getElementAt(row);
            if (value != null && (matcher = pattern.matcher(value.toString())).find()) {
                return this.createSearchResult(matcher, row, -1);
            }
            return null;
        }

        protected int getSize() {
            return JXList.this.getElementCount();
        }

        protected void moveMatchMarker() {
            JXList.this.setSelectedIndex(this.lastSearchResult.foundRow);
            if (this.lastSearchResult.foundRow >= 0) {
                JXList.this.ensureIndexIsVisible(this.lastSearchResult.foundRow);
            }
        }
    }

    public static class LinkController
    implements PropertyChangeListener {
        private Cursor oldCursor;
        private JXList list;

        public void propertyChange(PropertyChangeEvent evt) {
            if ("swingx.rollover".equals(evt.getPropertyName())) {
                this.rollover((JXList)evt.getSource(), (Point)evt.getOldValue(), (Point)evt.getOldValue());
            } else if ("swingx.clicked".equals(evt.getPropertyName())) {
                this.click((JXList)evt.getSource(), (Point)evt.getOldValue(), (Point)evt.getNewValue());
            }
        }

        public void install(JXList list) {
            this.release();
            this.list = list;
            list.addPropertyChangeListener(this);
            this.registerExecuteButtonAction();
        }

        public void release() {
            if (this.list == null) {
                return;
            }
            this.list.removePropertyChangeListener(this);
            this.unregisterExecuteButtonAction();
        }

        private void rollover(JXList list, Point oldLocation, Point newLocation) {
            this.setLinkCursor(list, newLocation);
            list.repaint();
        }

        private void click(JXList list, Point oldLocation, Point newLocation) {
            if (!this.isLinkElement(list, newLocation)) {
                return;
            }
            ListCellRenderer renderer = list.getCellRenderer();
            Component comp = renderer.getListCellRendererComponent(list, list.getModel().getElementAt(newLocation.y), newLocation.y, false, true);
            if (comp instanceof AbstractButton) {
                ((AbstractButton)comp).doClick();
                list.repaint();
            }
        }

        private void setLinkCursor(JXList list, Point location) {
            if (this.isLinkElement(list, location)) {
                this.oldCursor = list.getCursor();
                list.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                list.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }

        private boolean isLinkElement(JXList list, Point location) {
            if (location == null || location.y < 0) {
                return false;
            }
            return list.getModel().getElementAt(location.y) instanceof LinkModel;
        }

        private void unregisterExecuteButtonAction() {
            this.list.getActionMap().put(JXList.EXECUTE_BUTTON_ACTIONCOMMAND, null);
            KeyStroke space = KeyStroke.getKeyStroke("released SPACE");
            this.list.getInputMap(1).put(space, null);
        }

        private void registerExecuteButtonAction() {
            this.list.getActionMap().put(JXList.EXECUTE_BUTTON_ACTIONCOMMAND, this.createExecuteButtonAction());
            KeyStroke space = KeyStroke.getKeyStroke("released SPACE");
            this.list.getInputMap(1).put(space, JXList.EXECUTE_BUTTON_ACTIONCOMMAND);
        }

        private Action createExecuteButtonAction() {
            AbstractAction action = new AbstractAction(this){
                final /* synthetic */ LinkController this$1;
                {
                    this.this$1 = linkController;
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractButton button = this.getClickableRendererComponent();
                    if (button != null) {
                        button.doClick();
                        LinkController.access$0(this.this$1).repaint();
                    }
                }

                public boolean isEnabled() {
                    return this.isClickable();
                }

                private boolean isClickable() {
                    return this.getClickableRendererComponent() != null;
                }

                private AbstractButton getClickableRendererComponent() {
                    if (LinkController.access$0(this.this$1) == null || !LinkController.access$0(this.this$1).isEnabled() || !LinkController.access$0(this.this$1).hasFocus()) {
                        return null;
                    }
                    int leadRow = LinkController.access$0(this.this$1).getLeadSelectionIndex();
                    if (leadRow < 0) {
                        return null;
                    }
                    ListCellRenderer renderer = LinkController.access$0(this.this$1).getCellRenderer();
                    Component rendererComp = renderer.getListCellRendererComponent(LinkController.access$0(this.this$1), LinkController.access$0(this.this$1).getElementAt(leadRow), leadRow, false, true);
                    return rendererComp instanceof AbstractButton ? (AbstractButton)rendererComp : null;
                }
            };
            return action;
        }

        static /* synthetic */ JXList access$0(LinkController linkController) {
            return linkController.list;
        }
    }

    private class WrappingListModel
    extends AbstractListModel {
        private ListModel delegate;
        private ListDataListener listDataListener;

        public WrappingListModel(ListModel model) {
            this.setModel(model);
        }

        public void updateOnFilterContentChanged() {
            this.fireContentsChanged(this, -1, -1);
        }

        public void setModel(ListModel model) {
            ListModel old = this.getModel();
            if (old != null) {
                old.removeListDataListener(this.listDataListener);
            }
            this.delegate = model;
            this.delegate.addListDataListener(this.getListDataListener());
            this.fireContentsChanged(this, -1, -1);
        }

        private ListDataListener getListDataListener() {
            if (this.listDataListener == null) {
                this.listDataListener = this.createListDataListener();
            }
            return this.listDataListener;
        }

        private ListDataListener createListDataListener() {
            ListDataListener l = new ListDataListener(this){
                final /* synthetic */ WrappingListModel this$1;
                {
                    this.this$1 = wrappingListModel;
                }

                public void intervalAdded(ListDataEvent e) {
                    this.contentsChanged(e);
                }

                public void intervalRemoved(ListDataEvent e) {
                    this.contentsChanged(e);
                }

                public void contentsChanged(ListDataEvent e) {
                    JXList.access$0(WrappingListModel.access$1(this.this$1)).lock();
                    WrappingListModel.access$0(this.this$1, this, -1, -1);
                    this.this$1.updateSelection(e);
                    WrappingListModel.access$1(this.this$1).getFilters().flush();
                }
            };
            return l;
        }

        protected void updateSelection(ListDataEvent e) {
            if (e.getType() == 2) {
                JXList.this.getSelectionMapper().removeIndexInterval(e.getIndex0(), e.getIndex1());
            } else if (e.getType() == 1) {
                int minIndex = Math.min(e.getIndex0(), e.getIndex1());
                int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
                int length = maxIndex - minIndex + 1;
                JXList.this.getSelectionMapper().insertIndexInterval(minIndex, length, true);
            } else {
                JXList.this.getSelectionMapper().clearModelSelection();
            }
        }

        public ListModel getModel() {
            return this.delegate;
        }

        public int getSize() {
            return JXList.this.getFilters().getOutputSize();
        }

        public Object getElementAt(int index) {
            return JXList.this.getFilters().getValueAt(index, 0);
        }

        static /* synthetic */ void access$0(WrappingListModel wrappingListModel, Object object, int n, int n2) {
            wrappingListModel.fireContentsChanged(object, n, n2);
        }

        static /* synthetic */ JXList access$1(WrappingListModel wrappingListModel) {
            return wrappingListModel.JXList.this;
        }
    }

    protected static class ListAdapter
    extends ComponentAdapter {
        private final JXList list;

        public ListAdapter(JXList component) {
            super(component);
            this.list = component;
        }

        public JXList getList() {
            return this.list;
        }

        public boolean hasFocus() {
            return this.list.isFocusOwner() && this.row == this.list.getLeadSelectionIndex();
        }

        public int getRowCount() {
            return this.list.getWrappedModel().getSize();
        }

        public Object getValueAt(int row, int column) {
            return this.list.getWrappedModel().getElementAt(row);
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.list.getElementAt(row);
        }

        public void setValueAt(Object aValue, int row, int column) {
            throw new UnsupportedOperationException("Method getFilteredValueAt() not yet implemented.");
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean isSelected() {
            return this.list.isSelectedIndex(this.row);
        }

        public String getColumnName(int columnIndex) {
            return "Column_" + columnIndex;
        }

        public String getColumnIdentifier(int columnIndex) {
            return null;
        }
    }

    private class DelegatingRenderer
    implements ListCellRenderer {
        private LinkRenderer linkRenderer;
        private ListCellRenderer delegateRenderer;

        public DelegatingRenderer(ListCellRenderer delegate) {
            this.setDelegateRenderer(delegate);
        }

        public void setDelegateRenderer(ListCellRenderer delegate) {
            if (delegate == null) {
                delegate = new DefaultListCellRenderer();
            }
            this.delegateRenderer = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = null;
            comp = value instanceof LinkModel ? this.getLinkRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus) : this.delegateRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (JXList.this.highlighters != null) {
                ComponentAdapter adapter = JXList.this.getComponentAdapter();
                adapter.column = 0;
                adapter.row = index;
                comp = JXList.this.highlighters.apply(comp, adapter);
            }
            return comp;
        }

        private LinkRenderer getLinkRenderer() {
            if (this.linkRenderer == null) {
                this.linkRenderer = new LinkRenderer();
            }
            return this.linkRenderer;
        }

        public void setLinkVisitor(ActionListener linkVisitor) {
            this.getLinkRenderer().setVisitingDelegate(linkVisitor);
        }

        public void updateUI() {
            this.updateRendererUI(this.linkRenderer);
            this.updateRendererUI(this.delegateRenderer);
        }

        private void updateRendererUI(ListCellRenderer renderer) {
            Component comp;
            if (renderer instanceof JComponent) {
                ((JComponent)((Object)renderer)).updateUI();
            } else if (renderer != null && (comp = renderer.getListCellRendererComponent(JXList.this, null, -1, false, false)) instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
        }
    }
}

