/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.EditorPaneLinkVisitor;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXEditorPaneTest;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.action.LinkAction;

public class JXHyperlinkTest
extends InteractiveTestCase {
    static /* synthetic */ Class class$0;

    public JXHyperlinkTest() {
        super("JXHyperlinkLabel Test");
    }

    public void testDummy() {
    }

    public void interactiveTestUnderlineButton() {
        AbstractAction action = new AbstractAction("LinkModel@somewhere"){

            public void actionPerformed(ActionEvent e) {
            }
        };
        JXHyperlink hyperlink = new JXHyperlink(action);
        JXFrame frame = this.wrapInFrame(hyperlink, "show underline - no link action");
        frame.setSize(200, 200);
        frame.setVisible(true);
    }

    public void interactiveTestLink() throws Exception {
        EditorPaneLinkVisitor visitor = new EditorPaneLinkVisitor();
        LinkModel link = new LinkModel("Click me!", null, JXEditorPaneTest.class.getResource("resources/test.html"));
        LinkAction linkAction = new LinkAction(link);
        linkAction.setVisitingDelegate(visitor);
        JXHyperlink hyperlink = new JXHyperlink(linkAction);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JScrollPane(visitor.getOutputComponent()));
        panel.add((Component)hyperlink, "South");
        JXFrame frame = this.wrapInFrame(panel, "simple hyperlink");
        frame.setSize(200, 200);
        frame.setVisible(true);
    }

    public void interactiveTestTableLinkRenderer() {
        EditorPaneLinkVisitor visitor = new EditorPaneLinkVisitor();
        JXTable table = new JXTable(this.createModelWithLinks());
        table.setDefaultLinkVisitor(visitor);
        JXFrame frame = this.wrapWithScrollingInFrame(table, visitor.getOutputComponent(), "show link renderer in table");
        frame.setVisible(true);
    }

    public void interactiveTestListLinkRenderer() {
        EditorPaneLinkVisitor visitor = new EditorPaneLinkVisitor();
        JXList list = new JXList(this.createListModelWithLinks(20));
        list.setLinkVisitor(visitor);
        JXFrame frame = this.wrapWithScrollingInFrame(list, visitor.getOutputComponent(), "show link renderer in list");
        frame.setVisible(true);
    }

    private ListModel createListModelWithLinks(int count) {
        DefaultListModel<LinkModel> model = new DefaultListModel<LinkModel>();
        int i = 0;
        while (i < count) {
            try {
                LinkModel link = new LinkModel("a link text " + i, null, new URL("http://some.dummy.url" + i));
                if (i == 1) {
                    URL url = JXEditorPaneTest.class.getResource("resources/test.html");
                    link = new LinkModel("a link text " + i, null, url);
                }
                model.addElement(link);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return model;
    }

    private TableModel createModelWithLinks() {
        Object[] columnNames = new String[]{"text only", "Link editable", "Link not-editable", "Bool editable", "Bool not-editable"};
        DefaultTableModel model = new DefaultTableModel(columnNames, 0){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            public boolean isCellEditable(int row, int column) {
                return !this.getColumnName(column).contains("not");
            }
        };
        int i = 0;
        while (i < 4) {
            try {
                LinkModel link = new LinkModel("a link text " + i, null, new URL("http://some.dummy.url" + i));
                if (i == 1) {
                    URL url = JXEditorPaneTest.class.getResource("resources/test.html");
                    link = new LinkModel("a link text " + i, null, url);
                }
                model.addRow(new Object[]{"text only " + i, link, link, Boolean.TRUE, Boolean.TRUE});
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return model;
    }

    public static void main(String[] args) throws Exception {
        JXHyperlinkTest test = new JXHyperlinkTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }
}

