/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import org.jdesktop.swingx.plaf.JXHyperlinkAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXHyperlink
extends JButton {
    public static final String uiClassID = "HyperlinkUI";
    private boolean hasBeenVisited = false;
    private Color unclickedColor = new Color(0, 51, 255);
    private Color clickedColor = new Color(153, 0, 153);

    static {
        LookAndFeelAddons.contribute(new JXHyperlinkAddon());
    }

    public JXHyperlink() {
    }

    public JXHyperlink(Action action) {
        super(action);
        this.init();
    }

    public Color getUnclickedColor() {
        return this.unclickedColor;
    }

    public void setClickedColor(Color color) {
        Color old = this.getClickedColor();
        this.clickedColor = color;
        if (this.isVisited()) {
            this.setForeground(this.getClickedColor());
        }
        this.firePropertyChange("clickedColor", old, this.getClickedColor());
    }

    public Color getClickedColor() {
        return this.clickedColor;
    }

    public void setUnclickedColor(Color color) {
        Color old = this.getUnclickedColor();
        this.unclickedColor = color;
        if (!this.isVisited()) {
            this.setForeground(this.getUnclickedColor());
        }
        this.firePropertyChange("unclickedColor", old, this.getUnclickedColor());
    }

    protected void setVisited(boolean visited) {
        boolean old = this.isVisited();
        this.hasBeenVisited = visited;
        this.setForeground(this.isVisited() ? this.getClickedColor() : this.getUnclickedColor());
        this.firePropertyChange("visited", old, this.isVisited());
    }

    protected boolean isVisited() {
        return this.hasBeenVisited;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(final Action a) {
        final PropertyChangeListener superListener = super.createActionPropertyChangeListener(a);
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("visited".equals(evt.getPropertyName())) {
                    JXHyperlink.this.setVisitedFromActionProperty(a);
                } else {
                    superListener.propertyChange(evt);
                }
            }
        };
        return l;
    }

    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        this.setVisitedFromActionProperty(a);
    }

    private void setVisitedFromActionProperty(Action a) {
        Boolean visited = (Boolean)a.getValue("visited");
        this.setVisited(visited != null ? visited : false);
    }

    private void init() {
        this.setForeground(this.isVisited() ? this.getClickedColor() : this.getUnclickedColor());
    }

    public String getUIClassID() {
        return uiClassID;
    }
}

