/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jdesktop.swingx.ErrorReporter;
import org.jdesktop.swingx.IncidentInfo;
import org.jdesktop.swingx.util.WindowUtils;

public class JXErrorDialog
extends JDialog {
    private static final String DETAILS_EXPAND_TEXT = "Details >>";
    private static final String DETAILS_CONTRACT_TEXT = "Details <<";
    private static final String OK_BUTTON_TEXT = "Ok";
    private static final Icon icon = UIManager.getIcon("OptionPane.warningIcon");
    private static final String REPORT_BUTTON_TEXT = "Report...";
    private JLabel errorMessage;
    private JTextArea details;
    private JButton detailButton;
    private JScrollPane detailsScrollPane;
    private JButton reportButton;
    private static ErrorReporter reporter;
    private IncidentInfo incidentInfo;

    public JXErrorDialog(Frame owner) {
        super(owner, true);
        this.initGui();
    }

    public JXErrorDialog(Dialog owner) {
        super(owner, true);
        this.initGui();
    }

    private void initGui() {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.insets = new Insets(22, 12, 11, 17);
        this.getContentPane().add((Component)new JLabel(icon), gbc);
        this.errorMessage = new JLabel();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(12, 0, 0, 11);
        this.getContentPane().add((Component)this.errorMessage, gbc);
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(12, 0, 11, 5);
        JButton okButton = new JButton(OK_BUTTON_TEXT);
        this.getContentPane().add((Component)okButton, gbc);
        this.reportButton = new JButton(new ReportAction());
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(12, 0, 11, 5);
        this.getContentPane().add((Component)this.reportButton, gbc);
        this.reportButton.setVisible(false);
        this.detailButton = new JButton(DETAILS_EXPAND_TEXT);
        gbc.gridx = 3;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(12, 0, 11, 11);
        this.getContentPane().add((Component)this.detailButton, gbc);
        this.details = new JTextArea(7, 60);
        this.detailsScrollPane = new JScrollPane(this.details);
        this.detailsScrollPane.setVerticalScrollBarPolicy(22);
        this.details.setEditable(false);
        gbc.fill = 1;
        gbc.gridwidth = 4;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(6, 11, 11, 11);
        this.getContentPane().add((Component)this.detailsScrollPane, gbc);
        Dimension spPredictedSize = this.detailsScrollPane.getPreferredSize();
        Dimension newPanelSize = new Dimension(spPredictedSize.width + 15, 0);
        Container widthHolder = new Container();
        widthHolder.setMinimumSize(newPanelSize);
        widthHolder.setPreferredSize(newPanelSize);
        widthHolder.setMaximumSize(newPanelSize);
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 11, 11, 0);
        this.getContentPane().add((Component)widthHolder, gbc);
        int buttonLength = this.detailButton.getPreferredSize().width;
        int buttonHeight = this.detailButton.getPreferredSize().height;
        Dimension buttonSize = new Dimension(buttonLength, buttonHeight);
        okButton.setPreferredSize(buttonSize);
        this.reportButton.setPreferredSize(buttonSize);
        this.detailButton.setPreferredSize(buttonSize);
        okButton.addActionListener(new OkClickEvent());
        this.detailButton.addActionListener(new DetailsClickEvent());
    }

    private void setDetails(String details) {
        if (details == null || details.equals("")) {
            this.setDetailsVisible(false);
            this.detailButton.setVisible(false);
        } else {
            this.details.setText(details);
            this.setDetailsVisible(false);
            this.detailButton.setVisible(true);
        }
    }

    private void setDetailsVisible(boolean b) {
        if (b) {
            this.details.setCaretPosition(0);
            this.detailsScrollPane.setVisible(true);
            this.detailButton.setText(DETAILS_CONTRACT_TEXT);
        } else {
            this.detailsScrollPane.setVisible(false);
            this.detailButton.setText(DETAILS_EXPAND_TEXT);
        }
        this.pack();
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage.setText(errorMessage);
    }

    private void setIncidentInfo(IncidentInfo info) {
        this.incidentInfo = info;
        this.reportButton.setVisible(JXErrorDialog.getReporter() != null);
    }

    private IncidentInfo getIncidentInfo() {
        return this.incidentInfo;
    }

    public static void showDialog(Component owner, String title, Throwable e) {
        IncidentInfo ii = new IncidentInfo(title, null, null, e);
        JXErrorDialog.showDialog(owner, ii);
    }

    public static void showDialog(Component owner, String title, String errorMessage, Throwable e) {
        IncidentInfo ii = new IncidentInfo(title, errorMessage, null, e);
        JXErrorDialog.showDialog(owner, ii);
    }

    public static void showDialog(Component owner, String title, String errorMessage, String details) {
        IncidentInfo ii = new IncidentInfo(title, errorMessage, details);
        JXErrorDialog.showDialog(owner, ii);
    }

    public static void showDialog(Component owner, IncidentInfo info) {
        Window window = WindowUtils.findWindow(owner);
        JXErrorDialog dlg = owner instanceof Dialog ? new JXErrorDialog((Dialog)owner) : new JXErrorDialog((Frame)owner);
        dlg.setTitle(info.getHeader());
        dlg.setErrorMessage(info.getBasicErrorMessage());
        String details = info.getDetailedErrorMessage();
        if (details == null) {
            if (info.getErrorException() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                info.getErrorException().printStackTrace(pw);
                details = sw.toString();
            } else {
                details = "";
            }
        }
        dlg.setDetails(details);
        dlg.setIncidentInfo(info);
        dlg.setDefaultCloseOperation(2);
        dlg.pack();
        dlg.setLocationRelativeTo(owner);
        dlg.setVisible(true);
    }

    public static ErrorReporter getReporter() {
        return reporter;
    }

    public static void setReporter(ErrorReporter rep) {
        reporter = rep;
    }

    private final class OkClickEvent
    implements ActionListener {
        OkClickEvent() {
        }

        public void actionPerformed(ActionEvent e) {
            JXErrorDialog.this.setVisible(false);
            JXErrorDialog.this.dispose();
        }
    }

    private final class DetailsClickEvent
    implements ActionListener {
        DetailsClickEvent() {
        }

        public void actionPerformed(ActionEvent e) {
            JXErrorDialog.this.setDetailsVisible(!JXErrorDialog.this.detailsScrollPane.isVisible());
        }
    }

    public class ReportAction
    extends AbstractAction {
        public boolean isEnabled() {
            return JXErrorDialog.getReporter() != null;
        }

        public void actionPerformed(ActionEvent e) {
            JXErrorDialog.getReporter().reportIncident(JXErrorDialog.this.getIncidentInfo());
        }

        public Object getValue(String key) {
            if (key == "Name") {
                if (JXErrorDialog.getReporter() != null && JXErrorDialog.getReporter().getActionName() != null) {
                    return JXErrorDialog.getReporter().getActionName();
                }
                return JXErrorDialog.REPORT_BUTTON_TEXT;
            }
            return super.getValue(key);
        }
    }
}

