/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.html.HTMLDocument;
import junit.framework.TestCase;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.action.ActionFactory;
import org.jdesktop.swingx.action.ActionManager;

public class JXEditorPaneTest
extends TestCase {
    private static String testText = "This is an example of some text";
    private static boolean DEBUG = false;
    static /* synthetic */ Class class$0;

    public void testInitialization() throws IOException {
        URL url = JXEditorPaneTest.class.getResource("resources/test.html");
        JXEditorPane editor = new JXEditorPane();
        editor.setContentType("text/html");
        editor.setPage(url);
        JXEditorPaneTest.assertTrue((boolean)(editor.getDocument() instanceof HTMLDocument));
        JXEditorPaneTest.assertNotNull((Object)editor.getCaretListener());
        JXEditorPaneTest.assertNotNull((Object)editor.getUndoableEditListener());
        editor = new JXEditorPane("text/html", "");
        editor.setPage(url);
        JXEditorPaneTest.assertTrue((boolean)(editor.getDocument() instanceof HTMLDocument));
        JXEditorPaneTest.assertNotNull((Object)editor.getCaretListener());
        JXEditorPaneTest.assertNotNull((Object)editor.getUndoableEditListener());
        editor = new JXEditorPane();
        JXEditorPaneTest.assertFalse((boolean)(editor.getDocument() instanceof HTMLDocument));
        JXEditorPaneTest.assertNull((Object)editor.getCaretListener());
    }

    public void testRegistration() {
    }

    public void testCutPastePlain() {
        JXEditorPane editor = new JXEditorPane("text/plain", testText);
        this.editorCutPaste(editor);
    }

    public void testCutPasteHtml() {
        JXEditorPane editor = new JXEditorPane("text/html", testText);
        this.editorCutPaste(editor);
    }

    public void editorCutPaste(JEditorPane editor) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (DEBUG) {
            System.out.println("Document: " + editor.getDocument());
        }
        editor.select(4, 15);
        String selected = editor.getSelectedText();
        if (DEBUG) {
            System.out.println("Selected: \"" + selected + "\" length: " + selected.length());
        }
        ActionMap map = editor.getActionMap();
        Action cut = map.get("cut-to-clipboard");
        Action paste = map.get("paste-from-clipboard");
        JXEditorPaneTest.assertNotNull((Object)cut);
        JXEditorPaneTest.assertNotNull((Object)paste);
        String before = editor.getText();
        if (DEBUG) {
            System.out.println("Before cut: " + before);
        }
        cut.actionPerformed(new ActionEvent(editor, 0, (String)cut.getValue("ActionCommandKey")));
        if (DEBUG) {
            System.out.println("After cut: " + editor.getText());
        }
        editor.setCaretPosition(4);
        paste.actionPerformed(new ActionEvent(editor, 0, (String)paste.getValue("ActionCommandKey")));
        if (DEBUG) {
            System.out.println("After paste: " + editor.getText());
        }
        JXEditorPaneTest.assertEquals((String)before, (String)editor.getText());
    }

    public static void main(String[] args) throws Exception {
        Action[] actions = new Action[]{ActionFactory.createTargetableAction("cut-to-clipboard", "Cut", "C"), ActionFactory.createTargetableAction("copy-to-clipboard", "Copy", "P"), ActionFactory.createTargetableAction("paste-from-clipboard", "Paste", "T"), ActionFactory.createTargetableAction("undo", "Undo", "U"), ActionFactory.createTargetableAction("redo", "Redo", "R"), ActionFactory.createTargetableAction("left-justify", "Left", "L", true, "position-group"), ActionFactory.createTargetableAction("center-justify", "Center", "C", true, "position-group"), ActionFactory.createTargetableAction("right-justify", "Right", "R", true, "position-group"), ActionFactory.createTargetableAction("font-bold", "Bold", "B", true), ActionFactory.createTargetableAction("font-italic", "Italic", "I", true), ActionFactory.createTargetableAction("font-underline", "Underline", "U", true), ActionFactory.createTargetableAction("InsertUnorderedList", "UL", "U", true), ActionFactory.createTargetableAction("InsertOrderedList", "OL", "O", true), ActionFactory.createTargetableAction("InsertHR", "HR", "H")};
        ActionManager manager = ActionManager.getInstance();
        ActionContainerFactory factory = manager.getFactory();
        JToolBar toolbar = new JToolBar();
        int i = 0;
        while (i < actions.length) {
            manager.addAction(actions[i]);
            toolbar.add(factory.createButton(actions[i]));
            ++i;
        }
        URL url = JXEditorPaneTest.class.getResource("resources/test.html");
        JXEditorPane editor = new JXEditorPane(url);
        editor.setPreferredSize(new Dimension(600, 400));
        toolbar.add(editor.getParagraphSelector());
        JFrame frame = new JFrame("Editor tester");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)toolbar, "North");
        frame.getContentPane().add((Component)new JScrollPane(editor), "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

