/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.JXMonthView;

public class JXDatePicker
extends JComponent {
    private JFormattedTextField _dateField;
    private JXDatePickerPopup _popup;
    private JPanel _linkPanel;
    private long _linkDate;
    private MessageFormat _linkFormat;
    private JButton _popupButton;
    private int _popupButtonWidth = 20;
    private JXMonthView _monthView = new JXMonthView();
    private Handler _handler;
    private String _actionCommand = "selectionChanged";
    static /* synthetic */ Class class$0;

    public JXDatePicker() {
        this(System.currentTimeMillis());
    }

    public JXDatePicker(long millis) {
        this._monthView.setTraversable(true);
        this._dateField = this.createEditor();
        this._dateField.setName("dateField");
        this._dateField.setBorder(null);
        this._handler = new Handler();
        this._popupButton = new JButton();
        this._popupButton.setName("popupButton");
        this._popupButton.setRolloverEnabled(false);
        this._popupButton.addMouseListener(this._handler);
        this._popupButton.addMouseMotionListener(this._handler);
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this._popupButton.putClientProperty("doNotCancelPopup", preventHide);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        InputMap inputMap = this._dateField.getInputMap(0);
        inputMap.put(enterKey, "COMMIT_EDIT");
        ActionMap actionMap = this._dateField.getActionMap();
        actionMap.put("COMMIT_EDIT", new CommitEditAction());
        KeyStroke spaceKey = KeyStroke.getKeyStroke(32, 0, false);
        inputMap = this._popupButton.getInputMap(0);
        inputMap.put(spaceKey, "TOGGLE_POPUP");
        actionMap = this._popupButton.getActionMap();
        actionMap.put("TOGGLE_POPUP", new TogglePopupAction());
        this.add(this._dateField);
        this.add(this._popupButton);
        this.updateUI();
        this._linkDate = System.currentTimeMillis();
        this._linkPanel = new TodayPanel();
        this._dateField.setValue(new Date(millis));
    }

    public void updateUI() {
        int cols = UIManager.getInt("JXDatePicker.numColumns");
        if (cols == -1) {
            cols = 10;
        }
        this._dateField.setColumns(cols);
        String str = UIManager.getString("JXDatePicker.arrowDown.tooltip");
        if (str == null) {
            str = "Show Calendar";
        }
        this._popupButton.setToolTipText(str);
        Icon icon = UIManager.getIcon("JXDatePicker.arrowDown.image");
        if (icon == null) {
            icon = (Icon)UIManager.get("Tree.expandedIcon");
        }
        this._popupButton.setIcon(icon);
        Border border = UIManager.getBorder("JXDatePicker.border");
        if (border == null) {
            border = BorderFactory.createCompoundBorder(LineBorder.createGrayLineBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
        this._dateField.setBorder(border);
        String formatString = UIManager.getString("JXDatePicker.linkFormat");
        if (formatString == null) {
            formatString = "Today is {0,date, dd MMMM yyyy}";
        }
        this._linkFormat = new MessageFormat(formatString);
    }

    public void setFormats(String[] formats) {
        DateFormat[] dateFormats = new DateFormat[formats.length];
        int counter = formats.length - 1;
        while (counter >= 0) {
            dateFormats[counter] = new SimpleDateFormat(formats[counter]);
            --counter;
        }
        this.setFormats(dateFormats);
    }

    public void setFormats(DateFormat[] formats) {
        this._dateField.setFormatterFactory(new DefaultFormatterFactory(new JXDatePickerFormatter(formats)));
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter formatter;
        JFormattedTextField.AbstractFormatterFactory factory = this._dateField.getFormatterFactory();
        if (factory != null && (formatter = factory.getFormatter(this._dateField)) instanceof JXDatePickerFormatter) {
            return ((JXDatePickerFormatter)formatter).getFormats();
        }
        return null;
    }

    public void setDate(Date date) {
        this._dateField.setValue(date);
    }

    public void setDateInMillis(long millis) {
        this._dateField.setValue(new Date(millis));
    }

    public Date getDate() {
        return (Date)this._dateField.getValue();
    }

    public long getDateInMillis() {
        return ((Date)this._dateField.getValue()).getTime();
    }

    public JXMonthView getMonthView() {
        return this._monthView;
    }

    public void setMonthView(JXMonthView monthView) {
        this._monthView = monthView;
        this._popup = null;
    }

    public TimeZone getTimeZone() {
        return this._monthView.getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        this._monthView.setTimeZone(tz);
    }

    public void setLinkDate(long linkDate, String linkFormatString) {
        this._linkDate = linkDate;
        this._linkFormat = new MessageFormat(linkFormatString);
        this.setLinkPanel(new TodayPanel());
    }

    public JPanel getLinkPanel() {
        return this._linkPanel;
    }

    public void setLinkPanel(JPanel linkPanel) {
        if (this._popup != null) {
            this._popup.remove(this._linkPanel);
            this._popup.add((Component)linkPanel, "South");
        }
        this._linkPanel = linkPanel;
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    protected JFormattedTextField createEditor() {
        return new JFormattedTextField(new JXDatePickerFormatter());
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
    }

    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        super.setEnabled(value);
        this._dateField.setEnabled(value);
        this._popupButton.setEnabled(value);
    }

    public void setEditable(boolean value) {
        this._monthView.setEnabled(value);
        this._dateField.setEditable(value);
    }

    public boolean isEditable() {
        return this._dateField.isEditable();
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this._actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                if (e == null) {
                    e = new ActionEvent(this, 1001, this._actionCommand);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        this._dateField.setBounds(insets.left, insets.bottom, width - this._popupButtonWidth, height);
        this._popupButton.setBounds(width - this._popupButtonWidth + insets.left, insets.bottom, this._popupButtonWidth, height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dim = this._dateField.getPreferredSize();
        dim.width += this._popupButton.getPreferredSize().width;
        Insets insets = this.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        public void actionPerformed(ActionEvent ev) {
            JXDatePicker.this._handler.toggleShowPopup();
        }
    }

    private class CommitEditAction
    extends AbstractAction {
        public CommitEditAction() {
            super("CommitEditPopup");
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                JXDatePicker.this._dateField.commitEdit();
                JXDatePicker.this._dateField.setValue(JXDatePicker.this._dateField.getValue());
                JXDatePicker.this.fireActionPerformed();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener {
        private boolean _forwardReleaseEvent = false;

        Handler() {
        }

        public void mouseClicked(MouseEvent ev) {
        }

        public void mousePressed(MouseEvent ev) {
            if (!JXDatePicker.this.isEnabled()) {
                return;
            }
            if (!JXDatePicker.this.isEditable() && JXDatePicker.this._dateField.isEditValid()) {
                try {
                    JXDatePicker.this._dateField.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.toggleShowPopup();
        }

        public void mouseReleased(MouseEvent ev) {
            if (!JXDatePicker.this.isEnabled() || !JXDatePicker.this.isEditable()) {
                return;
            }
            if (this._forwardReleaseEvent) {
                ev = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, ev, JXDatePicker.this._monthView);
                JXDatePicker.this._monthView.dispatchEvent(ev);
                this._forwardReleaseEvent = false;
            }
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent ev) {
        }

        public void mouseDragged(MouseEvent ev) {
            if (!JXDatePicker.this.isEnabled() || !JXDatePicker.this.isEditable()) {
                return;
            }
            this._forwardReleaseEvent = true;
            if (!JXDatePicker.this._popup.isShowing()) {
                return;
            }
            ev = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, ev, JXDatePicker.this._monthView);
            JXDatePicker.this._monthView.dispatchEvent(ev);
        }

        public void mouseMoved(MouseEvent ev) {
        }

        public void toggleShowPopup() {
            if (JXDatePicker.this._popup == null) {
                JXDatePicker.this._popup = new JXDatePickerPopup();
            }
            if (!JXDatePicker.this._popup.isVisible()) {
                if (JXDatePicker.this._dateField.getValue() == null) {
                    JXDatePicker.this._dateField.setValue(new Date(JXDatePicker.this._linkDate));
                }
                DateSpan span = new DateSpan((Date)JXDatePicker.this._dateField.getValue(), (Date)JXDatePicker.this._dateField.getValue());
                JXDatePicker.this._monthView.setSelectedDateSpan(span);
                JXDatePicker.this._monthView.ensureDateVisible(((Date)JXDatePicker.this._dateField.getValue()).getTime());
                JXDatePicker.this._popup.show(JXDatePicker.this, 0, JXDatePicker.this.getHeight());
            } else {
                JXDatePicker.this._popup.setVisible(false);
            }
        }
    }

    protected class JXDatePickerPopup
    extends JPopupMenu
    implements ActionListener {
        public JXDatePickerPopup() {
            JXDatePicker.this._monthView.setActionCommand("MONTH_VIEW");
            JXDatePicker.this._monthView.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)JXDatePicker.this._monthView, "Center");
            if (JXDatePicker.this._linkPanel != null) {
                this.add((Component)JXDatePicker.this._linkPanel, "South");
            }
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if ("MONTH_VIEW".equals(command)) {
                DateSpan span = JXDatePicker.this._monthView.getSelectedDateSpan();
                JXDatePicker.this._dateField.setValue(span.getStartAsDate());
                JXDatePicker.this._popup.setVisible(false);
                JXDatePicker.this.fireActionPerformed();
            }
        }
    }

    private final class TodayPanel
    extends JXPanel {
        TodayPanel() {
            super(new FlowLayout());
            this.setDrawGradient(true);
            this.setGradientPaint(new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, 1.0f, Color.WHITE));
            JXHyperlink todayLink = new JXHyperlink(new TodayAction());
            Color textColor = new Color(16, 66, 104);
            todayLink.setUnclickedColor(textColor);
            todayLink.setClickedColor(textColor);
            this.add(todayLink);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(new Color(187, 187, 187));
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(new Color(221, 221, 221));
            g.drawLine(0, 1, this.getWidth(), 1);
        }

        private final class TodayAction
        extends AbstractAction {
            TodayAction() {
                super(JXDatePicker.this._linkFormat.format(new Object[]{new Date(JXDatePicker.this._linkDate)}));
            }

            public void actionPerformed(ActionEvent ae) {
                DateSpan span = new DateSpan(JXDatePicker.this._linkDate, JXDatePicker.this._linkDate);
                JXDatePicker.this._monthView.ensureDateVisible(span.getStart());
            }
        }
    }

    static class JXDatePickerFormatter
    extends JFormattedTextField.AbstractFormatter {
        private DateFormat[] _formats = null;

        public JXDatePickerFormatter() {
            this._formats = new DateFormat[3];
            String format = UIManager.getString("JXDatePicker.longFormat");
            if (format == null) {
                format = "EEE MM/dd/yyyy";
            }
            this._formats[0] = new SimpleDateFormat(format);
            format = UIManager.getString("JXDatePicker.mediumFormat");
            if (format == null) {
                format = "MM/dd/yyyy";
            }
            this._formats[1] = new SimpleDateFormat(format);
            format = UIManager.getString("JXDatePicker.shortFormat");
            if (format == null) {
                format = "MM/dd";
            }
            this._formats[2] = new SimpleDateFormat(format);
        }

        public JXDatePickerFormatter(DateFormat[] formats) {
            this._formats = formats;
        }

        public DateFormat[] getFormats() {
            return this._formats;
        }

        public Object stringToValue(String text) throws ParseException {
            Date result = null;
            ParseException pex = null;
            if (text == null || text.trim().length() == 0) {
                return null;
            }
            DateFormat[] dateFormatArray = this._formats;
            int n = 0;
            int n2 = dateFormatArray.length;
            while (n < n2) {
                DateFormat _format = dateFormatArray[n];
                try {
                    result = _format.parse(text);
                    pex = null;
                    break;
                }
                catch (ParseException ex) {
                    pex = ex;
                    ++n;
                }
            }
            if (pex != null) {
                throw pex;
            }
            return result;
        }

        public String valueToString(Object value) throws ParseException {
            if (value != null) {
                return this._formats[0].format(value);
            }
            return null;
        }
    }
}

