/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Point;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import junit.framework.TestCase;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXStatusBar;

public abstract class InteractiveTestCase
extends TestCase {
    protected Point frameLocation = new Point(0, 0);

    public InteractiveTestCase() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDot = className.lastIndexOf(".");
        String lastElement = className.substring(lastDot + 1);
        this.setName(lastElement);
    }

    public InteractiveTestCase(String testTitle) {
        super(testTitle);
    }

    public JXFrame wrapWithScrollingInFrame(JComponent component, String title) {
        JScrollPane scroller = new JScrollPane(component);
        return this.wrapInFrame(scroller, title);
    }

    public JXFrame wrapWithScrollingInFrame(JComponent leftComp, JComponent rightComp, String title) {
        Box comp = Box.createHorizontalBox();
        comp.add(new JScrollPane(leftComp));
        comp.add(new JScrollPane(rightComp));
        JXFrame frame = this.wrapInFrame(comp, title);
        return frame;
    }

    public JXFrame wrapInFrame(JComponent component, String title) {
        JXFrame frame = new JXFrame(title, false);
        JToolBar toolbar = new JToolBar();
        frame.getRootPaneExt().setToolBar(toolbar);
        frame.getContentPane().add("Center", component);
        frame.pack();
        frame.setLocation(this.frameLocation);
        if (this.frameLocation.x == 0) {
            frame.setDefaultCloseOperation(3);
            frame.setTitle(String.valueOf(title) + "  [close me and all tests will close]");
        }
        this.frameLocation.x += 30;
        this.frameLocation.y += 30;
        return frame;
    }

    public void runInteractiveTests(String regexPattern) throws Exception {
        this.setUp();
        Class<?> testClass = ((Object)((Object)this)).getClass();
        Method[] methods = testClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().matches(regexPattern)) {
                try {
                    methods[i].invoke((Object)this, null);
                }
                catch (Exception e) {
                    System.out.println("could not run interactive test: " + methods[i].getName());
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (methods.length == 0) {
            System.out.println("no test methods found matching the pattern: " + regexPattern);
        }
        this.tearDown();
    }

    public void runInteractiveTests() throws Exception {
        this.runInteractiveTests("interactive.*");
    }

    public void addAction(JXFrame frame, Action action) {
        JToolBar toolbar = frame.getRootPaneExt().getToolBar();
        if (toolbar != null) {
            JButton button = toolbar.add(action);
            button.setFocusable(false);
        }
    }

    public void addMessage(JXFrame frame, String message) {
        JXStatusBar statusBar = frame.getRootPaneExt().getStatusBar();
        if (statusBar == null) {
            statusBar = new JXStatusBar();
            frame.getRootPaneExt().setStatusBar(statusBar);
        }
        statusBar.add(new JLabel(message));
    }

    public static void setSystemLF(boolean system) {
        String lfName = system ? UIManager.getSystemLookAndFeelClassName() : UIManager.getCrossPlatformLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lfName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

