/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import org.jdesktop.swingx.InteractiveTestCase;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXFindBar;
import org.jdesktop.swingx.JXFindPanel;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.PatternModel;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.treetable.FileSystemModel;

public class FindTest
extends InteractiveTestCase {
    private URL editorURL;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        FindTest.setSystemLF(true);
        FindTest test = new FindTest();
        try {
            test.runInteractiveTests();
        }
        catch (Exception e) {
            System.err.println("exception when executing interactive tests:");
            e.printStackTrace();
        }
    }

    protected void setUp() {
        this.editorURL = FindTest.class.getResource("resources/test.txt");
    }

    public FindTest() {
        super("Find Action Test");
    }

    public void testWrapFindBar() {
        JXFindBar findBar = new JXFindBar();
        FindTest.assertTrue((String)"findbar must auto-wrap", (boolean)findBar.getPatternModel().isWrapping());
    }

    public void testTableResetStateWithNullSearchString() {
        JXTable table = new JXTable(new TestTableModel());
        int row = 39;
        int firstColumn = 0;
        String firstSearchText = table.getValueAt(row, firstColumn).toString();
        PatternModel model = new PatternModel();
        model.setRawText(firstSearchText);
        int foundIndex = table.getSearchable().search(model.getPattern(), -1);
        int foundColumn = ((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn;
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        FindTest.assertEquals((String)"column must be updated", (int)firstColumn, (int)foundColumn);
        int notFoundIndex = table.getSearchable().search((String)null);
        FindTest.assertEquals((String)"nothing found", (int)-1, (int)notFoundIndex);
        FindTest.assertEquals((String)"column must be reset", (int)-1, (int)((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn);
    }

    public void testTableResetStateWithEmptySearchString() {
        JXTable table = new JXTable(new TestTableModel());
        int row = 39;
        int firstColumn = 0;
        String firstSearchText = table.getValueAt(row, firstColumn).toString();
        PatternModel model = new PatternModel();
        model.setRawText(firstSearchText);
        int foundIndex = table.getSearchable().search(model.getPattern(), -1);
        int foundColumn = ((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn;
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        FindTest.assertEquals((String)"column must be updated", (int)firstColumn, (int)foundColumn);
        int notFoundIndex = table.getSearchable().search("");
        FindTest.assertEquals((String)"nothing found", (int)-1, (int)notFoundIndex);
        FindTest.assertEquals((String)"column must be reset", (int)-1, (int)((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn);
    }

    public void testTableIncremental() {
        JXTable table = new JXTable(new TestTableModel());
        String firstSearchText = "on";
        PatternModel model = new PatternModel();
        model.setRawText(firstSearchText);
        int foundIndex = table.getSearchable().search(model.getPattern(), -1);
        FindTest.assertEquals((String)"must return be found", (int)0, (int)foundIndex);
        String secondSearchText = "one";
        model.setRawText(secondSearchText);
        int secondFoundIndex = table.getSearchable().search(model.getPattern(), foundIndex);
        FindTest.assertEquals((String)"must not be found", (int)foundIndex, (int)secondFoundIndex);
    }

    public void testTableInvalidStartIndex() {
        JXTable table = new JXTable(new TestTableModel());
        String firstSearchText = "one";
        PatternModel model = new PatternModel();
        model.setRawText(firstSearchText);
        int foundIndex = table.getSearchable().search(model.getPattern(), -1);
        FindTest.assertEquals((String)"must return be found", (int)0, (int)foundIndex);
        int notFoundIndex = table.getSearchable().search(model.getPattern(), table.getRowCount() * 5, false);
        FindTest.assertEquals((String)"must not be found", (int)-1, (int)notFoundIndex);
    }

    public void testTableFoundNextColumnInPreviousRow() {
        JXTable table = new JXTable(new TestTableModel());
        int lastColumn = table.getColumnCount() - 1;
        int row = 39;
        int firstColumn = lastColumn - 1;
        String firstSearchText = table.getValueAt(row, firstColumn).toString();
        PatternModel model = new PatternModel();
        model.setRawText(firstSearchText);
        int foundIndex = table.getSearchable().search(model.getPattern(), -1, true);
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        int foundColumn = ((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn;
        FindTest.assertEquals((String)"column must be updated", (int)firstColumn, (int)foundColumn);
        int previousRow = row - 1;
        String secondSearchText = String.valueOf(previousRow);
        model.setRawText(secondSearchText);
        int secondFoundIndex = table.getSearchable().search(model.getPattern(), previousRow, true);
        FindTest.assertEquals((String)"must find match in same row", (int)previousRow, (int)secondFoundIndex);
        FindTest.assertEquals((String)"column must be updated", (int)lastColumn, (int)((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn);
    }

    public void testTableFoundPreviousColumnInSameRow() {
        JXTable table = new JXTable(new TestTableModel());
        int lastColumn = table.getColumnCount() - 1;
        int row = 90;
        String firstSearchText = table.getValueAt(row, lastColumn).toString();
        PatternModel model = new PatternModel();
        model.setRawText(firstSearchText);
        int foundIndex = table.getSearchable().search(model.getPattern(), -1, true);
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        String secondSearchText = table.getValueAt(row, lastColumn - 1).toString();
        model.setRawText(secondSearchText);
        int secondFoundIndex = table.getSearchable().search(model.getPattern(), foundIndex, true);
        FindTest.assertEquals((String)"must find match in same row", (int)foundIndex, (int)secondFoundIndex);
    }

    public void testTableFoundPreviousColumnInNextRow() {
        JXTable table = new JXTable(new TestTableModel());
        int row = 0;
        int firstColumn = 1;
        String firstSearchText = table.getValueAt(row, firstColumn).toString();
        int foundIndex = table.getSearchable().search(firstSearchText);
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        int foundColumn = ((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn;
        FindTest.assertEquals((String)"column must be updated", (int)firstColumn, (int)foundColumn);
        int nextRow = row + 1;
        String secondSearchText = String.valueOf(nextRow);
        int secondFoundIndex = table.getSearchable().search(secondSearchText, nextRow);
        FindTest.assertEquals((String)"must find match in same row", (int)nextRow, (int)secondFoundIndex);
        FindTest.assertEquals((String)"column must be updated", (int)0, (int)((JXTable.TableSearchable)table.getSearchable()).lastSearchResult.foundColumn);
    }

    public void testTableFoundNextColumnInSameRow() {
        JXTable table = new JXTable(new TestTableModel());
        int row = 90;
        int firstColumn = 0;
        String firstSearchText = table.getValueAt(row, firstColumn).toString();
        int foundIndex = table.getSearchable().search(firstSearchText);
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        String secondSearchText = table.getValueAt(row, firstColumn + 1).toString();
        int secondFoundIndex = table.getSearchable().search(secondSearchText, foundIndex);
        FindTest.assertEquals((String)"must find match in same row", (int)foundIndex, (int)secondFoundIndex);
    }

    public void testTableNotFoundWithoutWrapping() {
        JXTable table = new JXTable(new TestTableModel());
        int row = 90;
        String searchText = table.getValueAt(row, 0).toString();
        int foundIndex = table.getSearchable().search(searchText);
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        int notFoundIndex = table.getSearchable().search(searchText, foundIndex);
        FindTest.assertEquals((String)"nothing found after last line", (int)-1, (int)notFoundIndex);
    }

    public void testTableNotFoundLastRowWithoutWrapping() {
        JXTable table = new JXTable(new TestTableModel());
        int row = table.getRowCount() - 1;
        String searchText = table.getValueAt(row, 0).toString();
        int foundIndex = table.getSearchable().search(searchText);
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        int notFoundIndex = table.getSearchable().search(searchText, foundIndex);
        FindTest.assertEquals((String)"nothing found after last line", (int)-1, (int)notFoundIndex);
    }

    public void testTableNotFoundFirstRowWithoutWrapping() {
        JXTable table = new JXTable(new TestTableModel());
        int row = 0;
        PatternModel model = new PatternModel();
        String searchText = table.getValueAt(row, 0).toString();
        model.setRawText(searchText);
        int foundIndex = table.getSearchable().search(model.getPattern(), row + 1, true);
        FindTest.assertEquals((String)"last line found", (int)row, (int)foundIndex);
        int notFoundIndex = table.getSearchable().search(model.getPattern(), foundIndex, true);
        FindTest.assertEquals((String)"nothing found after last line", (int)-1, (int)notFoundIndex);
    }

    public void testEditorResetStateOnEmptySearchString() {
        JXEditorPane editor = new JXEditorPane();
        String text = "fou four";
        editor.setText(text);
        int foundIndex = editor.getSearchable().search("ou");
        FindTest.assertEquals((int)1, (int)foundIndex);
        int notFoundIndex = editor.getSearchable().search("", foundIndex);
        FindTest.assertEquals((int)-1, (int)notFoundIndex);
        FindTest.assertEquals((int)notFoundIndex, (int)((JXEditorPane.DocumentSearchable)editor.getSearchable()).lastFoundIndex);
    }

    public void testEditorResetStateOnNullSearchString() {
        JXEditorPane editor = new JXEditorPane();
        String text = "fou four";
        editor.setText(text);
        int foundIndex = editor.getSearchable().search("ou");
        FindTest.assertEquals((int)1, (int)foundIndex);
        int notFoundIndex = editor.getSearchable().search((String)null, foundIndex);
        FindTest.assertEquals((int)-1, (int)notFoundIndex);
        FindTest.assertEquals((int)notFoundIndex, (int)((JXEditorPane.DocumentSearchable)editor.getSearchable()).lastFoundIndex);
    }

    public void testEditorResetStateOnNullPattern() {
        JXEditorPane editor = new JXEditorPane();
        String text = "fou four";
        editor.setText(text);
        int foundIndex = editor.getSearchable().search("ou");
        FindTest.assertEquals((int)1, (int)foundIndex);
        int notFoundIndex = editor.getSearchable().search((Pattern)null, foundIndex);
        FindTest.assertEquals((int)-1, (int)notFoundIndex);
        FindTest.assertEquals((int)notFoundIndex, (int)((JXEditorPane.DocumentSearchable)editor.getSearchable()).lastFoundIndex);
    }

    public void testEditorBackwards() {
        JXEditorPane editor = new JXEditorPane();
        String text = "fou four";
        editor.setText(text);
        int first = 2;
        try {
            editor.getDocument().getText(first, editor.getDocument().getLength() - first);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        PatternModel model = new PatternModel();
        model.setRawText("fo");
        int foIndex = editor.getSearchable().search(model.getPattern(), text.length() - 1, true);
        FindTest.assertEquals((String)"found index must be last occurence", (int)text.lastIndexOf("fo"), (int)foIndex);
    }

    public void testEditorIncremental() {
        JXEditorPane editor = new JXEditorPane();
        String text = "fou four";
        editor.setText(text);
        String search = "fo";
        int first = editor.getSearchable().search(search, 0);
        FindTest.assertEquals((int)0, (int)first);
        String searchExt = String.valueOf(search) + "u";
        int second = editor.getSearchable().search(searchExt, first);
        FindTest.assertEquals((String)"index must be same if extension matches", (int)first, (int)second);
    }

    public void testEditorIncrementalNotFound() {
        JXEditorPane editor = new JXEditorPane();
        String text = "fou four";
        editor.setText(text);
        String search = "ou";
        int first = editor.getSearchable().search(search, 0);
        FindTest.assertEquals((int)1, (int)first);
        String searchExt = String.valueOf(search) + "u";
        try {
            int second = editor.getSearchable().search(searchExt, first);
            FindTest.assertEquals((String)"not found", (int)-1, (int)second);
        }
        catch (NullPointerException npe) {
            FindTest.fail((String)"npe");
        }
    }

    public void testEditorFindNext() {
        JXEditorPane editor = new JXEditorPane();
        String text = "fou four";
        editor.setText(text);
        String search = "fou";
        int first = editor.getSearchable().search(search, -1);
        FindTest.assertEquals((int)0, (int)first);
        int second = editor.getSearchable().search(search, first);
        FindTest.assertEquals((int)4, (int)second);
    }

    public void testEditorTolerateExceedingStartIndex() {
        JXEditorPane editor = new JXEditorPane();
        editor.setText("fou four");
        try {
            int foIndex = editor.getSearchable().search("fo", 20);
            FindTest.assertEquals((int)-1, (int)foIndex);
        }
        catch (Exception ex) {
            FindTest.fail((String)"search must not throw if index out off range");
        }
    }

    public void testEditorEmptyDocument() {
        JXEditorPane editor = new JXEditorPane();
        int foIndex = editor.getSearchable().search("fo", -1);
        FindTest.assertEquals((int)-1, (int)foIndex);
        foIndex = editor.getSearchable().search("fo", 0);
        FindTest.assertEquals((int)-1, (int)foIndex);
    }

    public void testEditorBoundarySearchIndex() {
        JXEditorPane editor = new JXEditorPane();
        editor.setText("f");
        int startOff = editor.getSearchable().search("f", -1);
        FindTest.assertEquals((String)"must return first occurence if startIndex if off", (int)0, (int)startOff);
        int foIndex = editor.getSearchable().search("fo", -1);
        FindTest.assertEquals((String)"must not find exceeding text", (int)-1, (int)foIndex);
        foIndex = editor.getSearchable().search("f", 0);
        FindTest.assertEquals((String)"must return first occurence from startIndex inclusively", (int)0, (int)foIndex);
    }

    public void testEditorFindMatchPosition() {
        JXEditorPane editor = new JXEditorPane();
        editor.setText("fou four");
        int foIndex = editor.getSearchable().search("fo", -1);
        FindTest.assertEquals((int)0, (int)foIndex);
    }

    public void testEditorFindMatch() {
        JXEditorPane editor = new JXEditorPane();
        editor.setText("fou four");
        int foIndex = editor.getSearchable().search("fo", -1);
        FindTest.assertEquals((String)"selected text must be equals to input", (String)"fo", (String)editor.getSelectedText());
        try {
            String textAt = editor.getText(foIndex, 2);
            FindTest.assertEquals((String)"fo", (String)textAt);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void testEditor() {
        URL url = FindTest.class.getResource("resources/test.txt");
        try {
            JXEditorPane editor = new JXEditorPane(url);
            int useIndex = -1;
            int lastIndex = -1;
            int i = 0;
            while (i < 9) {
                lastIndex = editor.getSearchable().search("four", useIndex);
                FindTest.assertTrue((lastIndex != -1 ? 1 : 0) != 0);
                FindTest.assertTrue((lastIndex != useIndex ? 1 : 0) != 0);
                FindTest.assertEquals((String)"Error text selection is incorrect", (String)"four", (String)editor.getSelectedText());
                useIndex = lastIndex;
                ++i;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error finding resource for JXEditorPane", ex);
        }
    }

    public void testTable() {
        JXTable table = new JXTable(new TestTableModel());
        int useIndex = -1;
        int lastIndex = -1;
        int i = 0;
        while (i < 100) {
            lastIndex = table.getSearchable().search("One", useIndex);
            FindTest.assertTrue((lastIndex != -1 ? 1 : 0) != 0);
            FindTest.assertTrue((lastIndex != useIndex ? 1 : 0) != 0);
            FindTest.assertEquals((String)"Row not selected", (int)lastIndex, (int)table.getSelectedRow());
            FindTest.assertEquals((String)"Column not selected", (int)0, (int)table.getSelectedColumn());
            String value = (String)table.getValueAt(table.getSelectedRow(), table.getSelectedColumn());
            FindTest.assertTrue((boolean)value.startsWith("One"));
            useIndex = lastIndex;
            ++i;
        }
    }

    public void testNullSearchable() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        JXFindPanel find = new JXFindPanel();
        find.match();
    }

    public void interactiveShowTree() {
        JXTree tree = new JXTree(new FileSystemModel());
        this.showComponent(tree, "Search in XTree");
    }

    public void interactiveShowList() {
        this.showComponent(new JXList((ListModel)new TestListModel()), "Search in XList");
    }

    public void interactiveShowTable() {
        this.showComponent(new JXTable(new TestTableModel()), "Search in XTable");
    }

    public void interactiveCompareFindStrategy() {
        JXTable first = new JXTable(new TestTableModel());
        first.setColumnControlVisible(true);
        AbstractAction action = new AbstractAction("toggle batch/incremental"){
            boolean useFindBar;

            public void actionPerformed(ActionEvent e) {
                this.useFindBar = !this.useFindBar;
                SearchFactory.getInstance().setUseFindBar(this.useFindBar);
            }
        };
        JXTreeTable second = new JXTreeTable(new FileSystemModel());
        JXFrame frame = this.wrapWithScrollingInFrame(first, second, "Batch/Incremental Search");
        this.addAction(frame, action);
        this.addMessage(frame, "Press ctrl-F to open search widget");
        frame.setVisible(true);
    }

    public void interactiveShowSplitPane() {
        this.showComponent(this.createEditor(), new JXTable(new TestTableModel()), "Targetable Search");
    }

    public void interactiveShowEditor() {
        this.showComponent(this.createEditor(), "Search in XEditorPane");
    }

    private JXEditorPane createEditor() {
        try {
            return new JXEditorPane(this.editorURL);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void showComponent(JComponent component, JComponent second, String title) {
        JXFrame frame = second != null ? this.wrapWithScrollingInFrame(component, second, title) : this.wrapWithScrollingInFrame(component, title);
        this.addMessage(frame, "Press ctrl-F to open search widget");
        frame.setSize(600, 400);
        frame.setVisible(true);
    }

    public void showComponent(JComponent component, String title) {
        this.showComponent(component, null, title);
    }

    public static class TestTableModel
    extends AbstractTableModel {
        public static String[] data = new String[]{"One", "Two", "Three", "Four", "Five"};

        public int getRowCount() {
            return 100;
        }

        public int getColumnCount() {
            return data.length;
        }

        public Object getValueAt(int row, int column) {
            this.checkCoordinates(row, column);
            StringBuffer buffer = new StringBuffer(data[column]);
            buffer.append(row);
            return buffer.toString();
        }

        private void checkCoordinates(int row, int column) {
            if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
                throw new IllegalArgumentException("coordinates invalid - row/column: " + row + "/" + column);
            }
        }
    }

    public static class TestListModel
    extends AbstractListModel {
        public int getSize() {
            return 100;
        }

        public Object getElementAt(int index) {
            int dataPos = index % TestTableModel.data.length;
            return String.valueOf(TestTableModel.data[dataPos]) + index;
        }
    }

    public static class TestSearchable
    extends JLabel
    implements Searchable {
        private boolean succeed;

        public TestSearchable() {
            this(false);
        }

        public TestSearchable(boolean succeed) {
            this.succeed = succeed;
        }

        public int search(String searchString) {
            return this.search(searchString, -1);
        }

        public int search(String searchString, int startIndex) {
            return this.succeed ? 100 : -1;
        }

        public int search(String searchString, int startIndex, boolean backward) {
            return this.succeed ? 100 : -1;
        }

        public int search(Pattern pattern) {
            return this.search(pattern, -1);
        }

        public int search(Pattern pattern, int startIndex) {
            return this.succeed ? 100 : -1;
        }

        public int search(Pattern pattern, int startIndex, boolean backwards) {
            return this.succeed ? 100 : -1;
        }
    }
}

