/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.PatternModel;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public abstract class AbstractPatternPanel
extends JXPanel {
    public static final String SEARCH_FIELD_LABEL = "searchFieldLabel";
    public static final String SEARCH_FIELD_MNEMONIC = "searchFieldLabel.mnemonic";
    public static final String SEARCH_TITLE = "searchTitle";
    public static final String MATCH_ACTION_COMMAND = "match";
    protected JLabel searchLabel;
    protected JTextField searchField;
    protected JCheckBox matchCheck;
    protected PatternModel patternModel;
    private ActionContainerFactory actionFactory;

    static {
        LookAndFeelAddons.getAddon();
    }

    public abstract void match();

    protected AbstractActionExt getAction(String key) {
        return (AbstractActionExt)this.getActionMap().get(key);
    }

    protected void initActions() {
        this.initPatternActions();
        this.initExecutables();
    }

    protected void initExecutables() {
        AbstractActionExt execute = this.createBoundAction(MATCH_ACTION_COMMAND, MATCH_ACTION_COMMAND);
        this.getActionMap().put("execute", execute);
        this.getActionMap().put(MATCH_ACTION_COMMAND, execute);
        this.refreshEmptyFromModel();
    }

    protected void initPatternActions() {
        ActionMap map = this.getActionMap();
        map.put("matchCase", this.createModelStateAction("matchCase", "setCaseSensitive", this.getPatternModel().isCaseSensitive()));
        map.put("wrapSearch", this.createModelStateAction("wrapSearch", "setWrapping", this.getPatternModel().isWrapping()));
        map.put("backwardsSearch", this.createModelStateAction("backwardsSearch", "setBackwards", this.getPatternModel().isBackwards()));
        map.put("matchIncremental", this.createModelStateAction("matchIncremental", "setIncremental", this.getPatternModel().isIncremental()));
    }

    protected String getUIString(String key) {
        String text = UIManager.getString("Search." + key);
        return text != null ? text : key;
    }

    protected AbstractActionExt createModelStateAction(String command, String methodName, boolean initial) {
        String actionName = this.getUIString(command);
        BoundAction action = new BoundAction(actionName, command);
        action.setStateAction();
        action.registerCallback(this.getPatternModel(), methodName);
        action.setSelected(initial);
        return action;
    }

    protected AbstractActionExt createBoundAction(String actionCommand, String methodName) {
        String actionName = this.getUIString(actionCommand);
        BoundAction action = new BoundAction(actionName, actionCommand);
        action.registerCallback(this, methodName);
        return action;
    }

    protected void refreshPatternFromModel() {
        if (this.getPatternModel().isIncremental()) {
            this.match();
        }
    }

    protected PatternModel getPatternModel() {
        if (this.patternModel == null) {
            this.patternModel = this.createPatternModel();
            this.patternModel.addPropertyChangeListener(this.getPatternModelListener());
        }
        return this.patternModel;
    }

    protected PatternModel createPatternModel() {
        PatternModel l = new PatternModel();
        return l;
    }

    protected PropertyChangeListener getPatternModelListener() {
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("pattern".equals(property)) {
                    AbstractPatternPanel.this.refreshPatternFromModel();
                } else if ("rawText".equals(property)) {
                    AbstractPatternPanel.this.refreshDocumentFromModel();
                } else if ("caseSensitive".equals(property)) {
                    AbstractPatternPanel.this.getAction("matchCase").setSelected((Boolean)evt.getNewValue());
                } else if ("wrapping".equals(property)) {
                    AbstractPatternPanel.this.getAction("wrapSearch").setSelected((Boolean)evt.getNewValue());
                } else if ("backwards".equals(property)) {
                    AbstractPatternPanel.this.getAction("backwardsSearch").setSelected((Boolean)evt.getNewValue());
                } else if ("incremental".equals(property)) {
                    AbstractPatternPanel.this.getAction("matchIncremental").setSelected((Boolean)evt.getNewValue());
                } else if ("empty".equals(property)) {
                    AbstractPatternPanel.this.refreshEmptyFromModel();
                }
            }
        };
        return l;
    }

    protected void refreshEmptyFromModel() {
        boolean enabled = !this.getPatternModel().isEmpty();
        this.getAction(MATCH_ACTION_COMMAND).setEnabled(enabled);
    }

    protected void refreshModelFromDocument() {
        this.getPatternModel().setRawText(this.searchField.getText());
    }

    protected void refreshDocumentFromModel() {
        if (this.searchField.getText().equals(this.getPatternModel().getRawText())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractPatternPanel.this.searchField.setText(AbstractPatternPanel.this.getPatternModel().getRawText());
            }
        });
    }

    protected DocumentListener getSearchFieldListener() {
        DocumentListener l = new DocumentListener(){

            public void changedUpdate(DocumentEvent ev) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            public void insertUpdate(DocumentEvent ev) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            public void removeUpdate(DocumentEvent ev) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }
        };
        return l;
    }

    protected void bind() {
        this.bindSearchLabel();
        this.searchField.getDocument().addDocumentListener(this.getSearchFieldListener());
        this.getActionContainerFactory().configureButton(this.matchCheck, (AbstractActionExt)this.getActionMap().get("matchCase"), null);
    }

    protected void bindSearchLabel() {
        this.searchLabel.setText(this.getUIString(SEARCH_FIELD_LABEL));
        String mnemonic = this.getUIString(SEARCH_FIELD_MNEMONIC);
        if (mnemonic != SEARCH_FIELD_MNEMONIC) {
            this.searchLabel.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        this.searchLabel.setLabelFor(this.searchField);
    }

    protected ActionContainerFactory getActionContainerFactory() {
        if (this.actionFactory == null) {
            this.actionFactory = new ActionContainerFactory(null);
        }
        return this.actionFactory;
    }

    protected void initComponents() {
        this.searchLabel = new JLabel();
        this.searchField = new JTextField(this.getSearchFieldWidth()){

            public Dimension getMaximumSize() {
                Dimension superMax = super.getMaximumSize();
                superMax.height = this.getPreferredSize().height;
                return superMax;
            }
        };
        this.matchCheck = new JCheckBox();
    }

    protected int getSearchFieldWidth() {
        return 15;
    }
}

