#ifndef _VERTEX_H // -*-C++-*-
#define _VERTEX_H

#include <math.h>
#include <ostream.h>

const double EPSILON = 1e-6;  // man, what a hack!

class Vertex
{
public:
    double v[3];

    Vertex()  { v[0]=0; v[1]=0; v[2]=0; }
    Vertex( const Vertex &x ) { v[0]=x[0]; v[1]=x[1]; v[2]=x[2]; }
    Vertex( double _v[3] ) { v[0]=_v[0]; v[1]=_v[1]; v[2]=_v[2]; }
    Vertex( float _v[3] ) { v[0]=_v[0]; v[1]=_v[1]; v[2]=_v[2]; }
    Vertex( double x, double y, double z ) { v[0]=x; v[1]=y; v[2]=z; }
    virtual ~Vertex() {};

    // operations
    Vertex &set( double a, double b, double c ) { v[0]=a; v[1]=b; v[2]=c;
    return *this; }
    Vertex &normalize() { scale(1/mag()); return *this; }
    Vertex &scale( double s ) { v[0]*=s; v[1]*=s; v[2]*=s; return *this; }

    // accessors
    double mag2() const { return v[0]*v[0]+v[1]*v[1]+v[2]*v[2]; }
    double mag() const { return sqrt( mag2() ); }
    double operator[]( int i ) const { return v[i]; }
    double &operator[]( int i ) { return v[i]; }

    // miscellaneous
    Vertex anyOrtho() const;
    int operator==( const Vertex &v1 ) const
	{ return v[0]==v1.v[0] && v[1]==v1.v[1] && v[2]==v1.v[2]; }
    void operator=( double b )
	{ v[0]=b; v[1]=b; v[2]=b; }
    static Vertex crossProduct( const Vertex &, const Vertex & );
    static Vertex crossProduct( const Vertex *a, const Vertex *b ) 
	{ return crossProduct( *a, *b ); }
    static double dotProduct( const Vertex &, const Vertex & );
    static double dotProduct( const Vertex *a, const Vertex *b )
	{ return dotProduct( *a, *b ); }
    static Vertex linkedTriad( const Vertex &, double, const Vertex & );
    static Vertex linkedTriad( const Vertex *a, double x, const Vertex *b )
	{ return linkedTriad( *a, x, *b ); }

    friend ostream &operator<<( ostream &, const Vertex & );
    friend int      compare( const Vertex &, const Vertex & );

    // arithmetic
    friend Vertex operator+( const Vertex &a, const Vertex &b )
    {
	return Vertex::linkedTriad( a, 1, b );
    }
    friend Vertex operator-( const Vertex &a, const Vertex &b )
    {
	return Vertex::linkedTriad( a, -1, b );
    }
    friend Vertex operator-( const Vertex &a )
    {
	Vertex b = a; b.scale( -1 ); return b;
    }
    friend Vertex operator*( double a, const Vertex &b )
    {
	Vertex c=b; c.scale(a); return c;
    }
    friend double operator*( const Vertex &a, const Vertex &b )
    {
	return Vertex::dotProduct( a, b );
    }
    friend Vertex operator^( const Vertex &a, const Vertex &b )
    {
	return Vertex::crossProduct( a, b );
    }

    // more operators
    friend void operator+=( Vertex &a, const Vertex &b )
    {
	a = a + b;
    }
    friend void operator-=( Vertex &a, const Vertex &b )
    {
	a = a - b;
    }
};


inline Vertex
midpoint( const Vertex &v1, const Vertex &v2 )
{
    return 0.5*(v1 + v2);
}

inline double
distance( const Vertex &v1, const Vertex &v2 )
{
    return (v1 - v2).mag();
}


inline double
distance2( const Vertex &v1, const Vertex &v2 )
{
    return (v1 - v2).mag2();
}

#endif // _VERTEX_H
