#include <math.h>
#include "vertex.h"

/////////////////////////////////////////////////////////////////////////////
//////////////////////////////  Vertex  /////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


Vertex
Vertex::anyOrtho() const
{
    Vertex ortho( 1, 1, 1 );
    double numerator = -( v[0] + v[1] + v[2] );
    int i;
    
    if( v[0] != 0 )
	i = 0;
    else if( v[1] != 0 )
	i = 1;
    else
	i = 2;

    ortho[i] = (numerator + v[i])/v[i];
    return ortho;
}
	
	

Vertex Vertex::crossProduct( const Vertex &a, const Vertex &b )
{
    Vertex c(
	a[1]*b[2] - b[1]*a[2],
	b[0]*a[2] - a[0]*b[2],
	a[0]*b[1] - b[0]*a[1] );
    return c;
}


double Vertex::dotProduct( const Vertex &a, const Vertex &b )
{
    return a[0]*b[0] + a[1]*b[1] + a[2]*b[2];
}



Vertex Vertex::linkedTriad( const Vertex &a, double s, const Vertex &b )
{
    Vertex c( a[0] + s*b[0], a[1] + s*b[1], a[2] + s*b[2] );
    return c;
}


ostream &operator<<( ostream &out, const Vertex &v )
{
    out << '(' << v[0] << ',' << v[1] << ',' << v[2] << ')';
    return out;
}


