#include <stdlib.h>
#include <iostream.h>
#include "vertex.h"
#include "darray.h"


class Triangle
{

public:
    Vertex v1;
    Vertex v2;
    Vertex v3;

    Triangle( const Vertex &_v1, const Vertex &_v2, const Vertex &_v3 )
	{ v1=_v1; v2=_v2; v3=_v3; }
    DArray<Triangle> subdivide();
};


void subdivide( DArray<Triangle> & );
void usage();
ostream &operator<<( ostream &, DArray<Triangle> & );

int
main( int argc, char **argv )
{
    if( argc != 2 )
	usage();
    int n = atoi( argv[1] );
    Vertex x( 1, 0, 0 );
    Vertex y( 0, 1, 0 );
    Vertex z( 0, 0, 1 );
    DArray<Triangle> a;

    a.add( new Triangle(z,x,y) );
    a.add( new Triangle(z,y,-x) );
    a.add( new Triangle(z,-x,-y) );
    a.add( new Triangle(z,-y,x) );

    a.add( new Triangle(-z,y,x) );
    a.add( new Triangle(-z,-x,y) );
    a.add( new Triangle(-z,-y,-x) );
    a.add( new Triangle(-z,x,-y) );
    for( int i=1; i<n; i++ )
	subdivide( a );
    cout << a;
    return 0;
}


DArray<Triangle>
Triangle::subdivide()
{
    DArray<Triangle> a;

    Vertex v12 = v1 + v2; v12.normalize();
    Vertex v23 = v2 + v3; v23.normalize();
    Vertex v31 = v3 + v1; v31.normalize();

    Triangle t1( v1, v12, v31 );
    Triangle t2( v2, v23, v12 );
    Triangle t3( v3, v31, v23 );
    Triangle t4( v12, v23, v31 );
    a.add( new Triangle(t1) );
    a.add( new Triangle(t2) );
    a.add( new Triangle(t3) );
    a.add( new Triangle(t4) );
    return a;
}

    

void
subdivide( DArray<Triangle> &a )
{
    DArray<Triangle> b;

    for( int i=0; i<a.length(); i++ )
	b.append( a[i]->subdivide() );
    a.clear( 1 );
    a = b;
}



void
usage()
{
    cout << "Usage: sphere n\n";
    cout << "Generates (inefficiently) a sphere.  n is the number of\n";
    cout << "subdivisions.  A Wavefront Object file is written to stdout.\n";
    cout << "n should be a small positive integer.\n";
    exit( 1 );
}


ostream &
operator<<( ostream &out, DArray<Triangle> &a )
{
    out << "# Vertices\n";
    for( int i=0; i<a.length(); i++ )
    {
	Triangle &t = *a[i];
	out.form( "v %g %g %g\n", t.v1[0], t.v1[1], t.v1[2] );
	out.form( "v %g %g %g\n", t.v2[0], t.v2[1], t.v2[2] );
	out.form( "v %g %g %g\n", t.v3[0], t.v3[1], t.v3[2] );
    }

    out << "# Normals\n";
    for( int i=0; i<a.length(); i++ )
    {
	Triangle &t = *a[i];
	out.form( "vn %g %g %g\n", t.v1[0], t.v1[1], t.v1[2] );
	out.form( "vn %g %g %g\n", t.v2[0], t.v2[1], t.v2[2] );
	out.form( "vn %g %g %g\n", t.v3[0], t.v3[1], t.v3[2] );
    }

    out << "# Faces\n";
    for( int i=0; i<a.length(); i++ )
    {
	int j = 3*i + 1;
	out.form( "f %d//%d %d//%d %d//%d\n", j, j, j+1, j+1, j+2, j+2 );
    }
    return out;
}
    



