#ifndef _DARRAY_H // -*-C++-*-
#define _DARRAY_H

#include <string.h>

#define foreach( I, A )   for( int I=0; I<(A).length(); I++ )


template<class T>
class DSArray
{
    T   **m_array;
    int   m_size;
    int   m_num;

    void assignFrom( const DSArray<T> &a )
    {
	m_array = new T *[a.m_size];
	memcpy( m_array, a.m_array, a.m_size*sizeof(T *) );
	m_size = a.m_size;
	m_num = a.m_num;
    }

public:
    /****** operations summary ******
	DSArray( int size=8 );
	DSArray( const DSArray<T> & );
	~DSArray();
	void clear();
	int add( T *obj );                 // appends to end of array
	void append( const DSArray<T> & );  // appends to the end
	T *remove( int i );                // moves everything else down
	void reverse();       
	int length() const;
	T *&operator[]( int i ) const;
	DSArray<T> &operator=( const DSArray<T> & );
     ********************************/

    DSArray( int size=8 )
    {
	m_array = new T *[size];
	m_size = size;
	m_num = 0;
    }

    DSArray( const DSArray<T> &a )
    {
	assignFrom( a );
    }


    ~DSArray()
    {
	delete m_array;
    }

    void clear()
    {
	m_num = 0;
    }

    int add( T *obj )
    {
	if( m_num == m_size )
	{
	    T **oldArray = m_array;
	    m_array = new T *[m_size*2];
	    memcpy( m_array, oldArray, m_size*sizeof(T *) );
	    m_size *= 2;
	    delete oldArray;
	}
	m_array[m_num] = obj;
	return m_num++;
    }

    void append( const DSArray<T> &a )
    {
	if( a.m_num )
	{
	    if( m_size < m_num+a.m_num )
	    {
		m_size = m_size>a.m_size ? 2*m_size : 2*a.m_size;
		T **array = new T *[m_size];
		memcpy( array, m_array, m_num*sizeof(T *) );
		delete m_array;
		m_array = array;
	    }
	    memcpy( m_array+m_num, a.m_array, a.m_num*sizeof(T *) );
	    m_num += a.m_num;
	}
    }

    T *remove( int i )
    {
	T *obj = m_array[i];
	if( i != m_num-1 )
	    memmove( m_array+i, m_array+i+1, (m_num-i-1)*sizeof(T *) );
	m_num--;
	return obj;
    }

    void reverse()
    {
	int i = m_num/2 + (m_num % 2);
	int j = m_num/2 - 1;

	for( ; i<m_num; i++,j-- )
	{
	    T *tmp = m_array[i];
	    m_array[i] = m_array[j];
	    m_array[j] = tmp;
	}
    }

    int length() const
    {
	return m_num;
    }

    T *&operator[]( int i ) const
    {
	return m_array[i];
    }

    DSArray<T> &operator=( const DSArray<T> &a )
    {
	delete m_array;
	assignFrom( a );
	return *this;
    }
};


template<class T>
class DArray : public DSArray<T>
{
public:
    DArray( int size=8 ) : DSArray<T>( size ) {}
    DArray( const DArray &a ) : DSArray<T>( a ) {}
    DArray( const DSArray<T> &a ) : DSArray<T>( a ) {}
    void clear( int del=0 )            // delete pointers if del==true
    {
	if( del )
	{
	    for( int i=0; i<length(); i++ )
	    {
		T *x = operator[]( i );
		if( x )
		    delete x;
	    }
	}
	DSArray<T>::clear();
    }
};


#endif // _DARRAY_H

