
#ifndef GLOBAL_H
#define GLOBAL_H


#include <stdio.h>   /* printf() */
#include <stdlib.h>  /* exit() */


#ifdef DEBUG
   /* convenient macro for printing vectors and points during debugging */
   #define PRINT(v) printf( "%f,%f,%f\n", (v).x(), (v).y(), (v).z() );

   /* convenient macro for printing matrices during debugging */
   #define PRINT_MATRIX(m) printf( \
      "%f,%f,%f,%f\n%f,%f,%f,%f\n%f,%f,%f,%f\n%f,%f,%f,%f\n--\n", \
      m( 0), m( 4), m( 8), m(12), \
      m( 1), m( 5), m( 9), m(13), \
      m( 2), m( 6), m(10), m(14), \
      m( 3), m( 7), m(11), m(15) \
   );

   #define ASSERT(exp) { if (!(exp)) { \
      printf( "Assertion error at line %d in %s\n", __LINE__, __FILE__ ); \
      exit( 1 ); \
   }}
   #define ASSERT_IS_EQUAL(a,b) { \
      ASSERT( (b) - 0.0005 < (a) && (a) < (b) + 0.0005 ); \
   }
   #define ASSERT_IS_NORMALIZED(v) { \
      ASSERT_IS_EQUAL(v.length(),1) \
   }
#else
   #define ASSERT(exp)
   #define ASSERT_IS_EQUAL(a,b)
   #define ASSERT_IS_NORMALIZED(v)
#endif


#endif /* GLOBAL_H */

