
#ifndef SERIALMOUSE_H
#define SERIALMOUSE_H

class SerialMouse {
private:
   int _fd;  // file descriptor

   // The stream of bytes that is read in has to be broken up into
   // packets of 3 bytes each.  When we read from the stream,
   // we won't necessarily start at the beginning of a packet;
   // we may begin reading in the middle of one and end in the
   // middle of another.  The below data members store our
   // position in the current packet, and the known contents of
   // the current packet.  Only when a packet is fully known is
   // it interpreted.
   unsigned short _state;
   char _packet[3];
public:
   bool leftBtn, middleBtn, rightBtn; // mouse buttons
   int x, y; // mouse position

   SerialMouse() : _fd( -1 ), _state( 0 ),
      leftBtn( false ), middleBtn( false ), rightBtn( false ),
      x( 0 ), y( 0 ) { }
   ~SerialMouse();

   // returns false upon failure
   bool init( char *port );

   // if there's input waiting to be read, this updates our
   // state; otherwise it returns false
   bool poll();
};

#endif /* SERIALMOUSE_H */

