
#include "Scene.h"
#include <GL/gl.h>


Scene::~Scene() {
   vector< Object* >::const_iterator it;
   for ( it = _objects.begin(); it != _objects.end(); ++it ) {
      delete *it;
   }
   _objects.clear();
}

void Scene::draw( DrawMode drawMode ) const {
   if ( drawMode==WIREFRAME ) glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
   else glEnable( GL_LIGHTING );
   glShadeModel( drawMode==SMOOTH_SHADED ? GL_SMOOTH : GL_FLAT );

   vector< Object* >::const_iterator it;
   for ( it = _objects.begin(); it != _objects.end(); ++it ) {
      (*it)->draw( true, drawMode==FLAT_SHADED, drawMode==SMOOTH_SHADED );
   }
   if ( drawMode==WIREFRAME ) glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
}

AlignedBox Scene::getBoundingBox() const {
   // We're called infrequently, and typically only after
   // something in the scene has changed (e.g. to update
   // the camera's far plane), so we don't bother
   // to cache the scene's bounding box.
   AlignedBox box;
   for ( OIndex i = 0; i < _objects.size(); ++i ) {
      box.bound( _objects[i]->getBoundingBox() );
   }
   return box;
}

bool Scene::intersectAll(
   const Ray& ray, list< OIndex >& objectList, bool cullBackfaces
) {
   ASSERT( objectList.empty() );
   FIndex face;
   float t;
   for ( OIndex i = 0; i < _objects.size(); ++i ) {

      // FIXME: we should first build a list of all the objects
      // whose bounding boxes intersect the ray, and then traverse
      // the list in order from nearest to farthest object.
      // To do this properly, we need to modify AlignedBox::intersects()
      // so that it returns bounds on t.

      if ( _objects[i]->getBoundingBox().intersects( ray ) ) {
         if ( _objects[i]->intersectNearest( ray, face, t, cullBackfaces ) ) {
            objectList.push_back( i );
         }
      }
   }
   return ! objectList.empty();
}

bool Scene::intersectNearest(
   const Ray& ray, OIndex & object, FIndex & face, float & t, bool cullBackfaces
) {
   bool intersectionFound = false;
   FIndex current_face;
   float current_t;
   for ( OIndex i = 0; i < _objects.size(); ++i ) {

      // FIXME: we should first build a list of all the objects
      // whose bounding boxes intersect the ray, and then traverse
      // the list in order from nearest to farthest object.
      // To do this properly, we need to modify AlignedBox::intersects()
      // so that it returns bounds on t.

      if ( _objects[i]->getBoundingBox().intersects( ray ) ) {
         if ( _objects[i]->intersectNearest(
            ray, current_face, current_t, cullBackfaces
         ) ) {
            if ( ! intersectionFound || current_t < t ) {
               intersectionFound = true;
               object = i;
               face = current_face;
               t = current_t;
            }
         }
      }
   }
   return intersectionFound;
}

