
#ifndef BRUSH_H
#define BRUSH_H


#include "Camera.h"
#include "Tool.h"
#include "Object.h"


class WorkSpace;


class Brush : public Tool {
private:
   WorkSpace & _workSpace;

   float _radius, _amplitude;
   Object * _savedObject;

   // the current intersection
   bool _isThereAnIntersection;
   Object * _currentObject;
   FIndex _currentFace;
   Ray _ray;
   float _t;
   Point3 _intersection;
   Vector3 _normal;
   list< VIndex > _coveredVertices;
   list< float > _distances;  // from covered vertices to intersection point
   list< FIndex > _coveredFaces;
   vector< float > _displacement;
   float _thresholdArea;

   static const float _cutoff;
   static const float _ln_cutoff;
   //
   // The decay function y==f(r) should be such that
   //
   //          f( 0 ) == _amplitude
   //    f( _radius ) == _cutoff * _amplitude
   //
   float decayFunction( float r ) const;
   float inverseDecayFunction( float y ) const;

   void computeIntersection();

   void paint( bool noRecursion = false );

public:
   Brush( WorkSpace& ws ) :
      _workSpace( ws ),
      _radius( 1 ), _amplitude( 1 ),
      _savedObject( 0 ),
      _isThereAnIntersection( false ),
      _currentObject( 0 )
   { }
   virtual ~Brush() { delete _savedObject; _savedObject = 0; }

   Point3 getCentreForOrbiting() {
      return _isThereAnIntersection ? _intersection : _camera->getTarget();
   }

   void increaseAmplitude( float delta ) {
      _amplitude += delta*0.005;
      if ( _amplitude < 0.1 ) _amplitude = 0.1;
   }
   void increaseRadius( float delta ) {
      _radius += delta*0.005;
      if ( _radius < 0.1 ) _radius = 0.1;
   }

   virtual Status press( int x, int y, bool LMB, bool MMB );
   virtual Status move( int x, int y );
   virtual Status release( int x, int y, bool LMB, bool MMB );

   virtual void draw();
};


#endif /* BRUSH_H */

