//
// utils.h
//
#ifndef _UTILS_H_
#define _UTILS_H_

#include <SDL.h>
#include <SDL_opengl.h>

#include <string>


namespace utils
{
	// useful constants
	//
	const double kEps = 0.000001;
	const double kCursorDepth = 0.985601;	// empirically determined z-buffer depth of world z=0 when eyeZ=6.5


	// functions
	//
	int powerOfTwo(int value);
	
	Uint32 getPixel(SDL_Surface* surface, int x, int y);
	void   setPixel(SDL_Surface* surface, int x, int y, Uint32 pixel);
	
	enum { FLIP_VERT = 1, FLIP_HORZ = 2 };
	SDL_Surface* flipSurface(SDL_Surface* surface, int flags);
	
	GLuint SDL_GL_LoadTextureFromFile(const std::string& filename, GLdouble* texcoord);
	GLuint SDL_GL_LoadTextureFromFile(const std::string& filename, Uint8 colorkeyRed, Uint8 colorkeyGreen, Uint8 colorkeyBlue, GLdouble* texcoord);
	GLuint SDL_GL_LoadTexture(SDL_Surface* surface, GLdouble* texcoord);
	GLuint SDL_GL_LoadTexture(SDL_Surface* surface, Uint8 colorkeyRed, Uint8 colorkeyGreen, Uint8 colorkeyBlue, GLdouble* texcoord);
}

#endif // _UTILS_H_
