//
// timer.h
//
#ifndef _TIMER_H_
#define _TIMER_H_

#include <SDL_timer.h>


// timer class that reports in seconds
//
class Timer
{
public:

	Timer() { reset(); }
	
	virtual ~Timer() {}
	
	void reset()
	{
		startTicks = SDL_GetTicks();
	}
	
	double elapsed() const
	{
		return (double(SDL_GetTicks() - startTicks) / 1000.0);
	}

private:

	int startTicks;
};

#endif // _TIMER_H_
