//
// entity.h
//
#ifndef _ENTITY_H_
#define _ENTITY_H_

#include <SDL_opengl.h>

#include <list>


// base class for game player / NPCs
//
class Entity
{
public:

	Entity();
	virtual ~Entity();
	
	virtual void update(double dt);
	virtual void display();

public:

	bool   killme;
	double x, y;	// position
	double dx, dy;	// velocity direction
	double speed;	// velocity magnitude
	double r, g, b;	// texture color modulation
	
	GLuint   texId;
	GLdouble texcoord[4];

protected:

	double z;		// used for display
	double vx, vy;	// unit velocity direction
};


// cursor entity
//
class Cursor : public Entity
{
public:

	Cursor();
	virtual ~Cursor();
	
	void setPos(int scrnX, int scrnY);
	
	virtual void display();

private:

	int sx, sy;		// screen coords
};


// bullet entity
//
class Bullet : public Entity
{
public:

	Bullet();
	virtual ~Bullet();
	
	void setTraj(double startX, double startY, double endX, double endY);
	
	virtual void update(double dt);
	virtual void display();

public:

	// use static tex info since all bullets use same info
	//
	static GLuint   texId;
	static GLdouble texcoord[4];

public:

	double dist;	// distance to travel
};

typedef std::list<Bullet*> BulletList;


// player entity
//
class Player : public Entity
{
public:

	Player();
	virtual ~Player();
	
	void    aim(int scrnX, int scrnY);
	Bullet* shoot(int scrnX, int scrnY);
	
	virtual void update(double dt);
	virtual void display();

public:

	GLuint   texId;
	GLdouble texcoord[4];

private:

	double turretZ;	// used for display
	double ax, ay;	// unit aim vector
};

#endif // _ENTITY_H_
