#! /usr/local/bin/wish 
#

set lib_path /usr/local/lib/tkpppload
set up_file /etc/ppp/UP
set label_font "-*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*"

load $lib_path/pppstat.so get_ppp_stats

# set up some global variables
set width 150
set height 50
set interval 1000
set last_in 0
set last_out 0
set mult_factor 1.2
set cap [expr 4300 * $mult_factor]
set bgcolor #000000
set icolor #00dd00
set ocolor #ff0000
set text_color #cccc00
set border_color #666666

# set up the geometry
frame .f -background $border_color
pack .f
image create photo graph -wi $width -he $height
label .f.lab -image graph -background $bgcolor
label .f.time_up -anchor sw -font $label_font -height 1 \
    -text Testing... -background $bgcolor -foreground $text_color
pack .f.lab -pady 1
pack .f.time_up -side bottom -fill x

# check for the up_file and get the "ppp link start time"
if [catch {open $up_file r} file_id] {
    puts stderr "the UP file is missing; link down?"
    exit -1
}
set link_start [gets $file_id]

# procedure which does the actual ppp stats retrieval
proc get_stats {} {
    global last_in last_out

    set result [get_ppp_stats]

    set new_in [lindex $result 0]
    set new_out [lindex $result 1]
    set in_bytes [expr $new_in - $last_in]
    set out_bytes [expr $new_out - $last_out]
    set last_in $new_in
    set last_out $new_out

    if { [string compare $result "link down"] == 0 } {
	puts "Link is down."
	exit -1
    }

    return [list $in_bytes $out_bytes]
}

# procedure which returns a string denoting how long the ppp link was up
proc get_time_up {} {
    global link_start

    set new_time [exec date "+ %s"]
    set up_time [expr $new_time - $link_start]
   
    if { $up_time < 60 } {
	set result "$up_time seconds"
    } elseif { $up_time < 3600 } {
	set result "[expr $up_time / 60] min, [expr $up_time % 60] secs"
    } else {
	set result "[expr $up_time / 3600] h, [expr ($up_time % 3600)/60] m, [expr $up_time % 60] s"
    }
   # hopefully won't need anymore gradations (days? months? years?)
    
    return $result
}

########### here is the 'main' code

# clear the graph
graph put $bgcolor -to 0 0 $width $height
#update

# get geometry (I will use this later)
set curr_geom [wm geometry .]
puts $curr_geom

# initialize $last_in and $last_out
get_stats

# there has GOT to be a better way to specify 'forever'
while { 2 >= 1 } {
    # move the graph left by a pixel
    graph copy graph -from 1 0 $width $height -to 0 0 [expr $width-1] \
	$height

    # get next batch of data
    set res [get_stats]
    set in_bytes [lindex $res 0]
    set out_bytes [lindex $res 1]

    # figure out the bar heights
    set ih [expr round([expr $in_bytes/ ($interval/1000.0) * $height\
			    / $cap]) ]
    set oh [expr round([expr $out_bytes/ ($interval/1000.0) * $height\
			    / $cap]) ]
    if { $ih > $height } {
	set ih $height
    }
    if { $oh > $height } {
	set oh $height
    }
    if { $ih < 0 } {
	if { $new_in == 0 } {
	    puts "Link is down."
	    exit -1
	}
	set ih 0
    }
    if { $oh < 0 } {
	if { $new_out == 0 } {
	   puts "Link is down."
	    exit -1
	}
	set oh 0
    }
    
    graph put $bgcolor -to [expr $width-1] 0 $width $height
    graph put $icolor -to [expr $width-1] $height $width [expr $height-$ih]
    graph put $ocolor -to [expr $width-1] 0 $width $oh

    # update the time online
    set time_up [get_time_up]
    .f.time_up configure -text "Up: $time_up"

    # wait for next interval
    set x 0
    after $interval {set x 1}
    vwait x
}

