#include <net/if.h>
#include <net/if_ppp.h>         /* BSD, Linux, NeXT, etc. */

#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>

#include <net/ppp_defs.h>
#include <sys/socket.h>

#include <tcl.h>

/////// prototypes
extern "C" {
  int Get_ppp_stats_Init(Tcl_Interp *interp);
  int GetStats(ClientData clientData, Tcl_Interp *interp,
		  int argc, char* argv[]);
}

/////// global data
int s;	// socket

int 
Get_ppp_stats_Init(Tcl_Interp *interp) {
  if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    perror("couldn't create IP socket");
    return TCL_ERROR;
  }

  Tcl_CreateCommand(interp, "get_ppp_stats", GetStats,
      (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

  Tcl_PkgProvide(interp, "get_ppp_stats", "0.1");
  return TCL_OK;
}

int 
GetStats(ClientData clientData, Tcl_Interp *interp,
    		int argc, char* argv[]) {

  int unit=0;			// later: cmd line parm
  struct ifpppstatsreq req;
  memset (&req, 0, sizeof (req));
  req.stats_ptr = (caddr_t) &req.stats;
  sprintf(req.b.ifr_name, "ppp%d", unit);

  if (ioctl(s, SIOCGPPPSTATS, &req) < 0) {
    if (errno == ENOTTY)
      fprintf(stderr, "kernel support missing\n");
//    else
//      perror("ioctl(SIOCGPPPSTATS)");
    sprintf(interp->result, "link down");
    return TCL_OK;	// the result will be interpreted as an error
  }

  sprintf(interp->result, "%u  %u", req.stats.p.ppp_ibytes, 
      					req.stats.p.ppp_obytes);
  return TCL_OK;
}

// stuff that we can find out ...
//struct pppstat  {
//    __u32       ppp_discards;   /* # frames discarded */
//
//    __u32       ppp_ibytes;     /* bytes received */
//    __u32       ppp_ioctects;   /* bytes received not in error */
//    __u32       ppp_ipackets;   /* packets received */
//    __u32       ppp_ierrors;    /* receive errors */
//    __u32       ppp_ilqrs;      /* # LQR frames received */
//
//    __u32       ppp_obytes;     /* raw bytes sent */
//    __u32       ppp_ooctects;   /* frame bytes sent */
//    __u32       ppp_opackets;   /* packets sent */
//    __u32       ppp_oerrors;    /* transmit errors */ 
//    __u32       ppp_olqrs;      /* # LQR frames sent */
//};
