#pragma once

#include <math.h>

class Matrix;

class Vector {
public:
	Vector(double, double, double);
	Vector(void) { x = y = z = 0; };
	
	Vector operator+(Vector&);
	Vector& operator+=(Vector&);
	Vector operator-(Vector&);
	Vector& operator-=(Vector&);
	Vector operator*(double);
	Vector& operator*=(double);
	Vector operator*(Matrix&); //Treat vector as [x,y,z], rather than vertical
	Vector& operator*=(Matrix&);

	Vector clone();
	
	double dotProd(Vector&);
	Vector crossProd(Vector&);

	bool normalize();	
	double magnitude() { return sqrt(x*x + y*y + z*z); };
	
	double x,y,z;
};

class Matrix {
public:
	Matrix() {};
	Matrix(double, double, double, double, double, double, double, double, double);
	Matrix(Vector*,Vector*,Vector*);

	double* operator[](int);

	Matrix clone();

	bool invert();

private:
	double mat[3][3];
};