#pragma once

#include <windows.h>
#include "math.h"

#define BUFF_WIDTH 400
#define BUFF_HEIGHT 400

#define SCREEN_DIST 554
#define CUT_OFF 50

//This represents a single pixel in memory
union Pixel {
	Pixel(unsigned long i) { bits = i; };
	Pixel(unsigned char r, unsigned char g, unsigned char b) { ABGR.r = r; ABGR.g = g; ABGR.b = b; ABGR.a = 0; };
	Pixel() {};

	unsigned long bits;
	struct _ABGR {
		unsigned char b;
		unsigned char g;
		unsigned char r;
		unsigned char a;
	} ABGR;
};

typedef union Pixel* pPixel;

//These are used for double-buffering
extern HDC g_backDC;
extern HBITMAP g_back_bmp;
extern pPixel g_back_buff;
extern unsigned long* g_zBuff;

class Camera;

class Light {
public:
	Light(Vector& pos, Pixel color) { this->pos = pos; this->color = color; };

	Vector pos;
	Pixel color;
};

//Triangle is the fundamental geometric shape, everything is composed of triangles
class Triangle {
public:
	Triangle(Vector&, Vector&, Vector&, Pixel);
	Triangle() {};
	//~Triangle();
	
public:
	Triangle rotateInto(Camera&);
	
	void draw();

	Vector points[3];
	Vector normal;
	Pixel color;
};

class GouraudTriangle {
public:
	GouraudTriangle(Vector&, Vector&, Vector&, Vector&, Vector&, Vector&, Pixel);
	
	GouraudTriangle rotateInto(Camera&);

	void draw();

	Vector points[3];
	Vector normals[3];
	Pixel color;
};


class Mesh {
public:
	Mesh() {};
	Mesh(int);
	~Mesh() { delete[] tri; };
	
	GouraudTriangle* operator[](int);
	
	bool add(GouraudTriangle*);
	int getSize() { return max; }

private:
	GouraudTriangle** tri;
	int max, num;
};

class Camera {
public:
	Camera(Vector&, Matrix&);
	Camera() {};

	void moveTo(Vector& p) { pos = p; }
	void rotateTo(Matrix& m) { transform = m; }

	void render(Triangle&);
	void render(GouraudTriangle&);
	void render(Mesh&);

	Vector pos;
	Matrix transform;
};

Matrix createTransform(Vector& dir, Vector& sky);