#include "math.h"

Vector::Vector(double a, double b, double c) {
	x = a;
	y = b;
	z = c;
}

Vector Vector::clone() {
	return Vector(x, y, z);
}

//Vector arithmetic
Vector Vector::operator+(Vector& b) {
	return Vector(x + b.x, y + b.y, z + b.z);
}

Vector& Vector::operator+=(Vector& b) {
	x += b.x;
	y += b.y;
	z += b.z;
	return *this;
}

Vector Vector::operator-(Vector& b) {
	return Vector(x - b.x, y - b.y, z - b.z);
}

Vector& Vector::operator-=(Vector& b) {
	x -= b.x;
	y -= b.y;
	z -= b.z;
	return *this;
}

Vector Vector::operator*(double b) {
	return Vector(x*b, y*b, z*b);
}

Vector& Vector::operator*=(double b) {
	x *= b;
	y *= b;
	z *= b;
	return *this;
}

Vector Vector::operator *(Matrix& b) {
	return Vector(b[0][0]*x + b[1][0]*y + b[2][0]*z,
				  b[0][1]*x + b[1][1]*y + b[2][1]*z,
				  b[0][2]*x + b[1][2]*y + b[2][2]*z);
}

Vector& Vector::operator *=(Matrix& b) {
	double tmp_x = b[0][0]*x + b[1][0]*y + b[2][0]*z;
	double tmp_y = b[0][1]*x + b[1][1]*y + b[2][1]*z;
	z = b[0][2]*x + b[1][2]*y + b[2][2]*z;
	x = tmp_x;
	y = tmp_y;
	return *this;
}

//More vector arithmetic, but no operator overloading would be intuitive for this
double Vector::dotProd(Vector& b) {
	return x*b.x + y*b.y + z*b.z;
}

Vector Vector::crossProd(Vector& b) {
	Vector temp;
	temp.x = y*(b.z) - z*(b.y);
	temp.y = z*(b.x) - x*(b.z);
	temp.z = x*(b.y) - y*(b.x);
	return temp;
}

bool Vector::normalize() {
	double mag = magnitude();
	if(!mag) return false;
	x /= mag;
	y /= mag;
	z /= mag;
	return true;
}