#include "engine.h"

void topoSort(int[], int[], int n);

Triangle::Triangle(Vector& a, Vector& b, Vector& c, Pixel col) {
	points[0] = a; points[1] = b; points[2] = c, color = col;
	Vector temp1 = points[2] - points[0];
	Vector temp2 = points[1] - points[0];
	normal = temp2.crossProd(temp1);
	normal.normalize();
}

Triangle Triangle::rotateInto(Camera& b) {
	Vector p1 = points[0] - b.pos;
	Vector p2 = points[1] - b.pos;
	Vector p3 = points[2] - b.pos;
	p1 *= b.transform;
	p2 *= b.transform;
	p3 *= b.transform;
	return Triangle(p1, p2, p3, color);
}

void Triangle::draw() {
	//Put the vertices into an array, then sort them based on the y-coordinate
	int xPts[3], yPts[3];
	for(int i = 0; i < 3; i++) {
		//xPts[i] = (int)transformedTri.points[i].x;
		//yPts[i] = (int)transformedTri.points[i].y;
		if(points[i].z < CUT_OFF)
			return;
		double t = SCREEN_DIST/points[i].z;
		double x = t*points[i].x;
		double y = t*points[i].y;
		xPts[i] = (int)(x + BUFF_WIDTH/2);
		yPts[i] = (int)(y + BUFF_HEIGHT/2);
	}
	topoSort(xPts, yPts, 3);

	//Calculate the color (flat-shading only so far)
	//Assume a light point forward from the camera
	double brightness = normal.dotProd(Vector(0,0,1));
	if(brightness < 0) brightness = -brightness;
	Pixel adjustedColor = color;
	adjustedColor.ABGR.r = (unsigned char)(color.ABGR.r * brightness);
	adjustedColor.ABGR.g = (unsigned char)(color.ABGR.g * brightness);
	adjustedColor.ABGR.b = (unsigned char)(color.ABGR.b * brightness);
	
	int x = xPts[0];
	int y = yPts[0];
	int dx = xPts[2] - xPts[0];
	if(dx < 0) dx = -dx;
	int dy = yPts[2] - yPts[0];
	if(dy < 0) dy = -dy;
	int eps = 0;
	int x_add = xPts[0] < xPts[2] ? 1 : -1;
	for(int i = 0; i < 2; i++) {
		int x2 = xPts[i];
		int dx2 = xPts[i+1] - xPts[i];
		if(dx2 < 0) dx2 = -dx2;
		int dy2 = yPts[i+1] - yPts[i];
		if(dy2 < 0) dy2 = -dy2;
		int eps2 = 0;
		int x2_add = xPts[i] < xPts[i+1] ? 1 : -1;
		for(; y < yPts[i+1]; y++) {
			if(y < 0) continue;
			if(y >= BUFF_HEIGHT) break;
			int left,right;
			if(x < x2) {
				left = x;
				right = x2;
			} else {
				left = x2;
				right = x;
			}
			if(left < 0) left = 0;
			if(right >= BUFF_HEIGHT) right = BUFF_HEIGHT-1;
			if(left < BUFF_HEIGHT && right >= 0) {
				//Draw the scanline
				pPixel pMemRight = g_back_buff + BUFF_WIDTH*y + right;
				for(pPixel pMem = g_back_buff + BUFF_WIDTH*y + left; pMem <= pMemRight; pMem++) {
					*pMem = adjustedColor;
				}
			}
			//Update the x-coords for the next scanline
			//We keep track of how far off of the actual edge we are by using eps and eps2
			//This rids us of floating point operations
			//Wierd algorithm, add more comments
			//Bresenham's line algorithm
			//Upper octants
			if(dx > dy) {
				while((eps << 1) < dx) {
					x += x_add;
					eps += dy;
				}
				eps -= dx;
			} else { //Lower octants
				eps += dx;
				if((eps << 1) >= dy) {
					x += x_add;
					eps -= dy;
				}
			}
			//Other side
			if(dx2 > dy2) {
				while((eps2 << 1) < dx2) {
					x2 += x2_add;
					eps2 += dy2;
				}
				eps2 -= dx2;
			} else { //Lower octants
				eps2 += dx2;
				if((eps2 << 1) >= dy2) {
					x2 += x2_add;
					eps2 -= dy2;
				}
			}
		}
	}
}

void topoSort(int x[], int y[], int n) {
	//Just insertion sort it, n shouldn't be very large (used for triangle vertices)
	//Lowest y to the left, x order unspecified
	for(int i = 1; i < n; i++) {
		for(int j = i; j > 0; j--) {
			if(y[j] >= y[j-1])
				break;
			int temp = y[j];
			y[j] = y[j-1];
			y[j-1] = temp;
			temp = x[j];
			x[j] = x[j-1];
			x[j-1] = temp;
		}
	}
}
