#include "math.h"

Matrix::Matrix(double r1c1, double r1c2, double r1c3, double r2c1, double r2c2, double r2c3, double r3c1, double r3c2, double r3c3) {
	mat[0][0] = r1c1;
	mat[0][1] = r1c2;
	mat[0][2] = r1c3;
	mat[1][0] = r2c1;
	mat[1][1] = r2c2;
	mat[1][2] = r2c3;
	mat[2][0] = r3c1;
	mat[2][1] = r3c2;
	mat[2][2] = r3c3;
}

// Ve Ve Ve
// ct ct ct
// or or or
Matrix::Matrix(Vector *v1, Vector *v2, Vector *v3) {
	/*mat[0][0] = v1->x;
	mat[0][1] = v1->y;
	mat[0][2] = v1->z;
	mat[1][0] = v2->x;
	mat[1][1] = v2->y;
	mat[1][2] = v2->z;
	mat[2][0] = v3->x;
	mat[2][1] = v3->y;
	mat[2][2] = v3->z;*/
	mat[0][0] = v1->x;
	mat[0][1] = v2->x;
	mat[0][2] = v3->x;
	mat[1][0] = v1->y;
	mat[1][1] = v2->y;
	mat[1][2] = v3->y;
	mat[2][0] = v1->z;
	mat[2][1] = v2->z;
	mat[2][2] = v3->z;
}

double* Matrix::operator [](int index) {
	return mat[index];
}

Matrix Matrix::clone() {
	return Matrix(mat[0][0], mat[0][1], mat[0][2],
				  mat[1][0], mat[1][1], mat[1][2],
				  mat[2][0], mat[2][1], mat[2][2]);
}

bool Matrix::invert() {
	Matrix id(1, 0, 0, 0, 1, 0, 0, 0, 1);
	for(int i = 0; i < 3; i++) {
		if(!mat[i][i]) {
			int swapRow = i+1;
			for(; !mat[swapRow][i]; swapRow++) {
				if(swapRow > 2)
					return false;
			}
			for(int j = 0; j < 3; j++) {
				double temp = mat[i][j];
				mat[i][j] = mat[swapRow][j];
				mat[swapRow][j] = temp;
				temp = id[i][j];
				id[i][j] = id[swapRow][j];
				id[swapRow][j] = temp;
			}
		}
		double mult = 1.0/mat[i][i];
		for(int j = 0; j < 3; j++) {
			mat[i][j] *= mult;
			id[i][j] *= mult;
		}
		for(int j = 0; j < 3; j++) {
			if(j == i) continue;
			mult = mat[j][i];
			for(int k = 0; k < 3; k++) {
				mat[j][k] -= mult * mat[i][k];
				id[j][k] -= mult * id[i][k];
			}
		}
	}
	
	//Inverse is now in id. Copy it over
	for(int i = 0; i < 3; i++)
		for(int j = 0; j < 3; j++)
			mat[i][j] = id[i][j];

	return true;
}