#include "engine.h"

void topoSort(int[], int[], int n);

GouraudTriangle::GouraudTriangle(Vector& p1, Vector& p2, Vector& p3, Vector& n1, Vector& n2, Vector& n3, Pixel col) {
	points[0] = p1; points[1] = p2; points[2] = p3;
	normals[0] = n1; normals[1] = n2; normals[2] = n3;
	normals[0].normalize();
	normals[1].normalize();
	normals[2].normalize();
	color = col;
}

GouraudTriangle GouraudTriangle::rotateInto(Camera& b) {
	Vector p1 = points[0] - b.pos;
	Vector p2 = points[1] - b.pos;
	Vector p3 = points[2] - b.pos;
	p1 *= b.transform;
	p2 *= b.transform;
	p3 *= b.transform;
	Vector n1 = normals[0] * b.transform;
	Vector n2 = normals[1] * b.transform;
	Vector n3 = normals[2] * b.transform;
	return GouraudTriangle(p1, p2, p3, n1, n2, n3, color);
}

typedef struct _ColorStep {
	long r,g,b;
	void operator+=(_ColorStep& a) {
		r += a.r;
		g += a.g;
		b += a.b;
	}
	Pixel toColor() { return Pixel((unsigned char)(r>>8),(unsigned char)(g>>8),(unsigned char)(b>>8)); }
} ColorStep; //Reduced clutter

void topoSort(int x[], int y[], int z[], int n);

void GouraudTriangle::draw() {
	//Put the vertices into an array, then sort them based on the y-coordinate
	int xPts[3], yPts[3], zPts[3];
	for(int i = 0; i < 3; i++) {
		//xPts[i] = (int)transformedTri.points[i].x;
		//yPts[i] = (int)transformedTri.points[i].y;
		if(points[i].z < CUT_OFF)
			return;
		double t = SCREEN_DIST/points[i].z;
		double x = t*points[i].x;
		double y = t*points[i].y;
		xPts[i] = (int)(x + BUFF_WIDTH/2);
		yPts[i] = (int)(y + BUFF_HEIGHT/2);
		zPts[i] = (int)points[i].z;
	}
	topoSort(xPts, yPts, zPts, 3);

	//Calculate the colors
	//Assume a light point forward from the camera
	Pixel colors[3];
	for(int i = 0; i < 3; i++) {
		double brightness = normals[i].dotProd(Vector(0,0,1));
		if(brightness < 0) brightness = -brightness;
		colors[i] = color;
		colors[i].ABGR.r = (unsigned char)(color.ABGR.r * brightness);
		colors[i].ABGR.g = (unsigned char)(color.ABGR.g * brightness);
		colors[i].ABGR.b = (unsigned char)(color.ABGR.b * brightness);
	}
	
	//Uses fixed point math, 8 bits for fractional part
	long x = (long)xPts[0] << 8;
	int y = yPts[0];
	unsigned long z = (unsigned long)zPts[0] << 8;
	long m = ((long)(xPts[2]-xPts[0])<<8)/((long)(yPts[2] - y));
	long zm = ((long)(zPts[2]-zPts[0])<<8)/((long)(yPts[2] - y));
	ColorStep color = {colors[0].ABGR.r << 8, colors[0].ABGR.g << 8, colors[0].ABGR.b << 8};
	ColorStep colorStep;
	colorStep.r = ((long)(colors[2].ABGR.r-colors[0].ABGR.r)<<8)/((long)(yPts[2] - y));
	colorStep.g = ((long)(colors[2].ABGR.g-colors[0].ABGR.g)<<8)/((long)(yPts[2] - y));
	colorStep.b = ((long)(colors[2].ABGR.b-colors[0].ABGR.b)<<8)/((long)(yPts[2] - y));
	for(int i = 0; i < 2; i++) {
		long x2 = (long)xPts[i] << 8;
		long m2 = ((long)(xPts[i+1]-xPts[i])<<8)/((long)(yPts[i+1] - yPts[i]));
		unsigned long z2 = (unsigned long)zPts[i] << 8;
		long zm2 = ((long)(zPts[i+1]-zPts[i])<<8)/((long)(yPts[i+1] - yPts[i]));
		ColorStep color2 = {colors[i].ABGR.r << 8, colors[i].ABGR.g << 8, colors[i].ABGR.b << 8};
		ColorStep colorStep2;
		colorStep2.r = ((long)(colors[i+1].ABGR.r-colors[i].ABGR.r)<<8)/((long)(yPts[i+1] - yPts[i]));
		colorStep2.g = ((long)(colors[i+1].ABGR.g-colors[i].ABGR.g)<<8)/((long)(yPts[i+1] - yPts[i]));
		colorStep2.b = ((long)(colors[i+1].ABGR.b-colors[i].ABGR.b)<<8)/((long)(yPts[i+1] - yPts[i]));
		for(; y < yPts[i+1]; y++) {
			long left,right;
			ColorStep lcolor;
			ColorStep step;
			unsigned long lz;
			long zstep;
			long dx = (x2 - x)>>8;
			if(dx == 0) {
				left = x;
				right = x2;
				lcolor = color;
				step.r = 0;
				step.g = 0;
				step.b = 0;
				lz = z;
				zstep = 0;
			} else if(x < x2) {
				left = x;
				right = x2;
				lcolor = color;
				step.r = (color2.r - color.r)/dx;
				step.g = (color2.g - color.g)/dx;
				step.b = (color2.b - color.b)/dx;
				lz = z;
				zstep = ((signed long)(z2 - z))/dx;
			} else {
				left = x2;
				right = x;
				lcolor = color2;
				step.r = (color2.r - color.r)/dx;
				step.g = (color2.g - color.g)/dx;
				step.b = (color2.b - color.b)/dx;
				lz = z2;
				zstep = ((signed long)(z2 - z))/dx;
			}
			if(y < 0) continue;
			if(y >= BUFF_HEIGHT) break;
			if(left < BUFF_WIDTH<<8 && right >= 0) {
				long dl = (left < 0) ? 0 : left>>8;
				long dr = (right >= BUFF_WIDTH<<8) ? BUFF_WIDTH-1 : right>>8;
				//Draw the scanline
				pPixel pMemRight = g_back_buff + BUFF_WIDTH*y + dr;
				unsigned long *pZBuff = g_zBuff + BUFF_WIDTH*y + dl;
				for(pPixel pMem = g_back_buff + BUFF_WIDTH*y + dl; pMem <= pMemRight; pMem++, pZBuff++) {
					if(*pZBuff > lz) {
						*pMem = lcolor.toColor();
						lcolor += step;
						*pZBuff = lz;
					}
					lz += zstep;
				}
			}
			x += m;
			x2 += m2;
			color += colorStep;
			color2 += colorStep2;
			z += zm;
			z2 += zm2;
		}
	}
}

void topoSort(int x[], int y[], int z[], int n) {
	//Just insertion sort it, n shouldn't be very large (used for triangle vertices)
	//Lowest y to the left, x order unspecified
	for(int i = 1; i < n; i++) {
		for(int j = i; j > 0; j--) {
			if(y[j] >= y[j-1])
				break;
			int temp = y[j];
			y[j] = y[j-1];
			y[j-1] = temp;
			temp = x[j];
			x[j] = x[j-1];
			x[j-1] = temp;
			temp = z[j];
			z[j] = z[j-1];
			z[j-1] = temp;
		}
	}
}
