#include "engine.h"

void topoSort(int[], int[], int n);

Camera::Camera(Vector& p, Matrix& t) {
	pos = p; transform = t;
}

//Left-handed
Matrix createTransform(Vector& dir, Vector& sky) {
	Vector forward = dir.clone();
	Vector right = sky.crossProd(dir);
	Vector up = dir.crossProd(right);
	forward.normalize();
	right.normalize();
	up.normalize();
	Matrix temp(&right, &up, &forward);
	//temp.invert();
	return temp;
}

void Camera::render(Mesh& mesh) {
	for(int i = 0; i < mesh.getSize(); i++) {
		if(!mesh[i])
			return;
		render(*mesh[i]);
	}
}

void Camera::render(Triangle& tri) {
	Triangle transformedTri = tri.rotateInto(*this);
	transformedTri.draw();
}
void Camera::render(GouraudTriangle& tri) {
	GouraudTriangle transformedTri = tri.rotateInto(*this);
	transformedTri.draw();
}
